
#include <LiquidCrystal.h>
#include <EEPROM.h>
#include "macro_pins.h"


LiquidCrystal lcd(84, 83, 82, 81, 80, 79, 78);

void setup() {
  
	lcd.begin(16, 2);

	analogReference(EXTERNAL); //DO NOT CHANGE!

	TRISD = (B11111111 << 8 ) + B11111111; //Set to input for starters
  
	sw[0] = 22;
	sw[1] = 26;
	sw[2] = 28;
	sw[3] = 30;
		
	sw[4] = 25;
	sw[5] = 27;
	sw[6] = 29;
	sw[7] = 31;  

	pinMode(52, INPUT);
	pinMode(53, INPUT);	
	
	for (int x = 0 ; x < 8 ; x++) {
	
		pinMode(sw[x], INPUT);
	
	}
	

	if (digitalRead(MacSwitch) == 0 ) {	//Macro switch pressed on boot?

		while(digitalRead(MacSwitch) == 0) {
		
		//Wait for button to be released...
		
		}
	
		ClearMem();
		
	}

	Display();
	
}

void loop() {

	
	

	if (digitalRead(MacSwitch) == 0) {		//Macro programming switch pressed?	

		Program();	

	}


	for(int x = 0; x < 8; x++) {
	
		if (digitalRead(sw[x]) == 0) {		//External switch pressed?
		
			Macro(x);						//Execute macro # based off the switch
			
			TRISD = (B11111111 << 8 ) + B11111111; //Set back to input
	
			Display();
		
		}
		
	}



}

void Macro(unsigned char MX) {

	lcd.clear();
	lcd.setCursor(0, 0); 	
	lcd.print("MACRO: ");
	lcd.print(MX + 1, DEC);

	MemPos = MX * 128;						//Starting point of memory	
	MemTop = MemPos + 126;					//Set limit of memory.
	
	Bmsb = B11111111;						//Starting flag
	Blsb = B11111111;						//Starting flag

	LATD = 65535;							//Start with no buttons pressed
	
	TRISD = 0;  //Set port to OUTPUT
	
	g = 1;									//Reset exit flag
	
	while(g) {						//Keep going until end flag (0)
	
		Bmsb = EEPROM.read(MemPos);
		Blsb = EEPROM.read(MemPos + 1);

		if (Blsb == EndFlag) {			//End of file flag?
		
			return;							//Exit flag
		
		}
		
		TRISD = (Bmsb << 8 ) + Blsb;
		LATD = (Bmsb << 8 ) + Blsb;			//Put data on the line

											//Fire analog triggers if need be
											
		if ((Bmsb & B00100000) == 0) {		//Is left trigger bit zero?

			//Set left trigger.
			pinMode(52, OUTPUT);
			digitalWrite(52, 1);
			
		}
		else {								//Set as input, null		
			pinMode(52, INPUT);		
		}
		

		if ((Bmsb & B00010000) == 0) {		//Is left trigger bit zero?

			//Set right trigger.
			pinMode(53, OUTPUT);
			digitalWrite(53, 1);
			
		}
		else {								//Set as input, null		
			pinMode(53, INPUT);		
		}	

		
		
		MemPos += 2;
		
		lcd.setCursor(0, 1);				//For debug only ...
		lcd.print(LATD, BIN);

		//lcd.setCursor(10, 0); 	
		//lcd.print(MemPos, DEC);				//... For debug only 

		if (digitalRead(MacSwitch) == 0 or (MemPos == MemTop + 2)) {		//Macro programming switch pressed?	

			g = 0;	

		}		
		
		
		delay(100);
		
	}

	while(digitalRead(MacSwitch) == 0) {
	
	//Wait for button to be released...
	
	}	
	
	pinMode(50, INPUT);
	pinMode(51, INPUT);
	
}

void Program() {

	while(digitalRead(MacSwitch) == 0) {
	
	//Wait for button to be released...
	
	}

	lcd.clear();
	lcd.setCursor(0, 0); 	
	lcd.print("Click switch");
	lcd.setCursor(0, 1); 	
	lcd.print("to program...");

	g = 10;
  
	while(g == 10) {							//Repeat until we get a valid value
  
		for(int x = 0; x < 8; x++) {
		
			if (digitalRead(sw[x]) == 0) {		//External switch pressed?
			
				g = x;						//Execute macro # based off the switch
			
			}
		}
  
	}
	
	lcd.clear();
	lcd.setCursor(0, 0); 	
	lcd.print("Enter macro #");
	lcd.print(g + 1, DEC);

	TRISD = (B11111111 << 8 ) + B11111111; //Set to input for starters
	
	MemPos = g * 128;						//Starting point of memory	
	MemTop = MemPos + 126;					//Set limit of memory.
	
	g = 0;									//End loop flag
	Bmsb = 255;								//Starting check
	
	Load = 65535;							//Set check flag
	
	while(g == 0) {							//Wait until something is pressed

		Load = PORTD;

		if (analogRead(14) > 128) {
		
			Load -= 8192;
		
		}

		delay(1);
		
		if (analogRead(15) > 128) {
		
			Load -= 4096;
		
		}		

		if (Load != 65535) {				//A button pressed?
		
			g = 1;
		
		}

				
	}

	EEPROM.write(MemPos, Load >> 8);		//Store top byte...
	EEPROM.write(MemPos + 1, Load & B11111111); //Store bottom byte

	MemPos += 2;

	lcd.clear();
	lcd.setCursor(0, 0); 	
	lcd.print("Capturing!");
	lcd.setCursor(0, 1); 	
	lcd.print("MACRO to end");	
	delay(100);

	g = 0;
	
	while(g == 0) {

		Load = PORTD;
		
		if (analogRead(14) > 128) {
		
			Load -= 8192;
		
		}

		delay(1);
		
		if (analogRead(15) > 128) {
		
			Load -= 4096;
		
		}		
		
		
		EEPROM.write(MemPos, Load >> 8);		//Store top byte...
		EEPROM.write(MemPos + 1, Load & B11111111); //Store bottom byte
	
		delay(99);
		
		MemPos += 2;
		
		if ((MemPos == MemTop) or (digitalRead(MacSwitch) == 0 )) {				//Out of memory?
			g = 1;
		}

	}


	EEPROM.write(MemPos, EndFlag);			//End of file flag
	EEPROM.write(MemPos + 1, EndFlag);		//End of file flag

		
	lcd.clear(); 
	lcd.print("Done!");

	delay(1500);
	
	Display();
	
	while(digitalRead(MacSwitch) == 0) {
	
	//Wait for button to be released...
	
	}

	
}

void Display() {

	lcd.clear();
	lcd.print("XBOX 360");
	lcd.setCursor(0, 1); 
	lcd.print("Macro Controller");  
  
}

void ClearMem() {

	for (int XX ; XX < 1024 ; XX++) {
	
		EEPROM.write(XX, B10101010); 
	
	}

	lcd.clear(); 
	lcd.print("Memory Erased!");

	delay(1000);

}

