                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
#include <EEPROM.h>
#include "macro_pins.h"

#include <LiquidCrystal.h>

LiquidCrystal lcd(22, 23, 25, 31, 30, 33, 32);

void setup() {

	lcd.begin(16, 2); 

	Display();
	
	analogReference(EXTERNAL); //DO NOT CHANGE!

	sw[0] = 46;
	sw[1] = 48;
	sw[2] = 50;
	sw[3] = 52;
	
	sw[4] = 47;
	sw[5] = 49;
	sw[6] = 51;
	sw[7] = 53;  

	for(int x = 0; x < 8; x++) {
	
		pinMode(sw[x], INPUT);
	
	}

}


void loop() {

	if (digitalRead(MacSwitch) == 0) {		//Macro programming switch pressed?	

		Program();	

	}

	for(int x = 0; x < 8; x++) {
	
		if (digitalRead(sw[x]) == 0) {		//External switch pressed?
		
			Macro(x);						//Execute macro # based off the switch
		
		}
	}
	
}

void Macro(unsigned char x) {

	lcd.clear();
	lcd.setCursor(0, 0); 	
	lcd.print("MACRO: ");
	lcd.print(X, DEC);

	MemPos = x * 128;						//Starting point of memory	

	Bmsb = B11111111;						//Starting flag
	
	while(Bmsb != 0) {						//Keep going until end flag (0)
	
		Bmsb = EEPROM.read(MemPos);

		MemPos += 1;
	
		if (bitRead(Bmsb, 7) == 0) {
			PressButton(A);
		}
		else {
			ReleaseButton(A);
		}

		if (bitRead(Bmsb, 6) == 0) {
			PressButton(B);
		}
		else {
			ReleaseButton(B);
		}
		
		if (bitRead(Bmsb, 5) == 0) {
			PressButton(X);
		}
		else {
			ReleaseButton(X);
		}

		if (bitRead(Bmsb, 4) == 0) {
			PressButton(Y);
		}
		else {
			ReleaseButton(Y);
		}	

		if (bitRead(Bmsb, 3) == 0) {
			PressButton(LB);
		}
		else {
			ReleaseButton(LB);
		}

		if (bitRead(Bmsb, 2) == 0) {
			PressButton(L3);
		}
		else {
			ReleaseButton(L3);
		}
		
		if (bitRead(Bmsb, 1) == 0) {
			PressButton(RB);
		}
		else {
			ReleaseButton(RB);
		}

		if (bitRead(Bmsb, 0) == 0) {
			PressButton(R3);
		}
		else {
			ReleaseButton(R3);
		}	

		delay(100);
		
	}
	
	ReleaseButton(L3);
	ReleaseButton(UP);
	ReleaseButton(RIGHT);
	ReleaseButton(LEFT);
	ReleaseButton(DOWN);
	ReleaseButton(X);

	ReleaseButton(Y);
	ReleaseButton(B);
	ReleaseButton(A);
	ReleaseButton(RB);
	ReleaseButton(LB);
	ReleaseButton(R3);	

	Display();
	
}

void Program() {

	while(digitalRead(MacSwitch) == 0) {
	
	//Wait for button to be released...
	
	}

	lcd.clear();
	lcd.setCursor(0, 0); 	
	lcd.print("Click switch");
	lcd.setCursor(0, 1); 	
	lcd.print("to program...");

	g = 10;
  
	while(g == 10) {							//Repeat until we get a valid value
  
		for(int x = 0; x < 8; x++) {
		
			if (digitalRead(sw[x]) == 0) {		//External switch pressed?
			
				g = x;						//Execute macro # based off the switch
			
			}
		}
  
	}
	
	lcd.clear();
	lcd.setCursor(0, 0); 	
	lcd.print("Enter macro #");
	lcd.print(g + 1, DEC);
	lcd.setCursor(0, 1); 	
	lcd.print("Press MACRO when done.");

	MemPos = g * 128;						//Starting point of memory	
	MemTop = MemPos + 127;					//Set limit of memory.
	
	g = 0;									//End loop flag

	Bmsb = 255;								//Starting check
	
	while(Bmsb == 255) {					//Wait until something is pressed
	
		GetButtons();						//Look for inputs
	
	}

	EEPROM.write(MemPos, Bmsb); 			//Write first valid section of data

	MemPos += 1;

	lcd.setCursor(0, 0); 	
	lcd.print("Capturing!");
	delay(100);
	
	while(g == 0) {

		GetButtons();						//Grab frame...
		EEPROM.write(MemPos, Bmsb); 		//...and write to memory	
		delay(100);
		
		MemPos += 1;
		
		if (MemPos == MemTop) {				//Out of memory?
			g = 1;
		}
		if (digitalRead(MacSwitch) == 0 ) {	//Switch pressed again?
			g = 1;
		}

	}
	
	EEPROM.write(MemPos, 0); 	

	lcd.clear(); 
	lcd.print("Done!");

	delay(1000);
	
	Display();
	
	while(digitalRead(MacSwitch) == 0) {
	
	//Wait for button to be released...
	
	}

	
}

void GetButtons() {

	Bmsb = B11111111;		//Set all to active high
	Blsb = B11111111;

	bitWrite(Bmsb, 7, digitalRead(A)); 	
	bitWrite(Bmsb, 6, digitalRead(B)); 	
	bitWrite(Bmsb, 5, digitalRead(X));
	bitWrite(Bmsb, 4, digitalRead(Y));
 	
	bitWrite(Bmsb, 3, digitalRead(LB)); 	
	bitWrite(Bmsb, 2, digitalRead(L3));
	bitWrite(Bmsb, 1, digitalRead(RB)); 	
	bitWrite(Bmsb, 0, digitalRead(R3)); 	
	
}

void PressButton(unsigned char buttonp) {

pinMode(buttonp, OUTPUT);			//Set to output
digitalWrite(buttonp, 0);			//Pull button low (pressed)

}

void ReleaseButton(unsigned char buttonp) {

pinMode(buttonp, INPUT);			//Go back to being an input

}

void Display() {

        lcd.setCursor(1,0);
        // print the letter:
        lcd.print("A");

}
