'  Bill Paxton Pinball - Main Game Kernel
'  2009 Benjamin J Heckendorn

'----------------------------------------------SETUP-----------------------------------------------------------

CON _clkmode = xtal1 + pll16x
    _xinfreq = 5_000_000       '80 MHz

    'buffSize = 200

VAR

    'GENERAL I/O variables
    long Light0       'Set up 32-bit binary light output 0
    long Light1       'Set up 32-bit binary light output 1
    long Blink0       'Blinking bit mask for Light output 0
    long Blink1       'Blinking bit mask for Light output 1  
    long Chase0       '3 stage "Chasing" bit sequence 0 - setup
    long Chase1       '3 stage "Chasing" bit sequence 1 - setup 
    long Chase0Bit    'Long of what is currently being lit / shifted
    long Chase1Bit    'Long of what is currently being lit / shifted  
    byte ChaseBit     'Which of the 3 bits is being lit / shift amount
    byte ChaseCount   'Kernel cycles between light change
    byte ChaseSpeed   'How often to change it (speeds up during game)
    byte Blinkcount
    long Solenoid     'Set up 32-bit binary solenoid output    
    long Sense        'Set up 32-bit binary sense input 0
    long Sense1       'Set up 32-bit binary sense input 1
    long g            'The Universal Ben Heckendorn random-use variable, in use since 1985.

    'GAMEPLAY / SOUND / DISPLAY variables
    byte Ball         'Starts at ball 1, should ball = 4 game is over (man)
    long Bored        'General purpose counter to cycle through screens, etc
    long BoredMode    'Counter for suggesting a new mode   
    word BoredDisplay 'Counter to show status. Resets when ANYTHING happens 
    byte Bumper[3]    'On/Off cycle/debounce count for Bumpers
    byte Bumpercount  'Detects rapid impacts of bumpers
    long CogstackS[70]'Stack space for Sound Clip Player
    long CogstackM[70]'Stack space for Music Player
    long CogstackD[70]'Stack space for display driver
    byte Credit       '1 credit per coin event.  
    byte CurrentPlayer'Player currently playing
    byte dstring[12]  'Used for MATCH mode
    byte Demoncount   'How many demons have been killed this cycle (bumper impacts)  
    byte Display      'Flag for what the display is doing. Currently 0=nothing, 2=animation, 3=scrolling 4=score bonus
    byte DisplayPriority 'Priority level of whatever is currently being displayed
    byte Drain        'Flag that lets the animator know the brain drained and thus don't show SCORE after animation finishes 
    byte Droptargets  'First 4 LSB counter for drop target status + cycle/debounce count for solenoid reset control     
    long Highscore    'Read from EEPROM and compare at end of game
    byte Inlane       'Inlane debounce 
    byte Interrupt    'Variable that says "do not interrupt this sound unless another no interrupt sound plays"
    byte Mode         'Movie mode the game is in. See value table
    byte ModeSuggest  'Mode the game suggests. Timed windows to start a mode and get a bonus.
    word ModeTimed    'Timer/counter flag for player to start 'ModeSuggested' modes.
    byte Outlane      'Outlane debounce   
    byte Players      'Total # of players in the game
    long PlayerScore[4]'Each player's score
    word Save         'Ball save timer. Usually is 1200 (about 5 seconds)
    long Score        'Should be obvious. Physical score limit = 999,999,999   
    byte Showbonus    'Flag that says "Once the display is clear, show the bonus"   
    byte SkillShotNum
    byte Sling[2]     'On/Off cycle/debounce count for Sling Targets  
    word SlingCount   'Counter for number of "sling shots" in succession
    byte SlingShot    'Number of hostiles vaporized. As with "demons", only tells us about it with 4+
    byte SlipStream   'Slipstream lane debounce   
    byte SoundGo      'Variable to pass into sound cog. If set to 0, file closes and sound stops.
    byte Soundload[7]
    byte Soundwait    'Flag for sound clip playback. =1, sound is playing so don't start another, =0 OK to start new sound.   
    byte StatusType   'What to show if it gets bored and needs status update
    word RandomBored  'Random "hit this" counter    
    byte Targetcount  'How many have been hit? (To increase music tension)  
    word Tilt         'Tilt timer. If it goes off twice in one cycle, we TILT

    'SCORE BONUS variables
    byte FishHeads
    byte FishBounce
    byte FishSung
    byte Hamms
    byte Demons       'Number of demons to kill
   
    'ALIENS mode variables
    long LEDgun       'Set up 32-bit binary LED "sentry gun" output 
    word Aliencount   'General purpose counter for Aliens mode
    word Alientarget
    byte Alienmusic   'Set to 1 if half the bumpers are hit... turns on more intense music
    byte Guncount
    byte Bulletleft
    byte Bulletright
    byte Bulletflag   'If a counter reaches 50%, Michael Beihn tells us about it.             
    word Bulletsub

    'BIG LOVE mode variables   
    byte Capture      'Bitwise checker for how many balls are captured for Big Love(Multiball) mode.
    byte Multiball    'Flag for Multiball mode. Starts at 3 to count active balls as they drain

    'APOLLO 13 variables
    byte Apollo       'Counter for progress in Apollo 13 mission. 1= Start 6= Success!
    byte LightApollo
    byte ApolloDebounce 'Apollo Trigger Debounce

    'TITANIC mode variables
    byte TitanicBounce 'Keeps Titanic optic sensor from re-triggering too fast
    byte Titanic      'Progress in Titanic mode
    byte TitanicMaze    'Flag to see if we're in the Titanic or not
         
    'HAMMS CAN variables
    byte Can          'Counter for Can Crush
    word CanBonus     'Timer for Can Bonus Mode

    'GOLF LANE variables
    word Golf         'Timer to sink Wife 3 shot after going through the golf lane
    byte Foreplay     'Counter if you hit Wife 3 before other wives

    'TRUE LIES mode variables
    byte Curtis       'Meter to see Paxton's progress with Jamie Lee Curtis
    byte TrueLiesCounter
    byte Safehouse

    'U-571 variables
    word Lightning    'Timer for lightning flashes in U-571 mode
    byte SubState     'What the submarine is doing
    word SubCount     'Counter to move sub backwards
    byte Waves        'Counter to step the wave motor

    'A SIMPLE PLAN variables
    word Wheel        'Timer for what color the wheel is on
    byte RightRamp    '=1 on the right ramp, =0 not

    'NEAR DARK mode variables
    long TheSun       'If the sun is on or not
    byte NeckBonus    'Multiplier for Near Dark mode
    byte DarkGolf     'Golf / sun debounce

    'CLUB DREAD mode variables
    byte Killer       'Drop target the killer is hiding under
    byte Drunk        'How many beers Pete drinks in Club Dread mode
    
'Mode 0 = None (starting default)
'Mode 1 = Aliens (clear drop targets before bullets run out)
'Mode 2 = Big Love (Multiball)
'Mode 3 = True Lies (get multiple left ramp shots, use safehouse multiplier)
'Mode 4 = Titanic (find all 5 pieces of the Heart of the Ocean)
'Mode 5 = Apollo 13 (get the broken spaceship safely home)
'Mode 6 = Near Dark (kill rednecks (sling targets) while avoiding the sun (left golf lane))
'Mode 7 = Weird Science (Protect your brother Wyatt's virginity by clearing drop targets)
'Mode 8 = Club Dread (hit lit drop target to uncover killer!)

' Audio / Display memory, buffers & variables         
VAR long parameter1  'to pass @buff1 to ASM
    long parameter2  'to pass @buff2 to ASM
    long parameter3  'to pass end flag to ASM                                                
    long parameter4  'to pass #samples to ASM
    long buff1[200]
    long buff2[200]
    long EOFFlag
    byte Header[44]

    byte Buffer[64]   'Load buffer for bitmaps
    byte Screen[256]  'Storage buffer for bitmaps. Allows them to be animated from memory, freeing up SD1 for audio 
     
    
OBJ

    fr  : "display"
    music : "play_music"
    sd1  : "FAT16-1"
    e : "I2C_driver" 
    'd : "debug"                 'I2C debug monitor.


'----------------------------------------------MAIN KERNEL-----------------------------------------------------------
PUB Main

Credit := 1                                          'For final both these values should equal 0 (erase them)
Players := 1

'd.clr
'd.dbtext(string("Debugger Ready!"),1)
  
'Initialize Pins

DIRA[8..15] := %11011011                              'Set pins for I/O sensors (PollIO section)
DIRA[16]~~

LEDgun   := 0                                         'Clear LED sentry gun
Solenoid := %00000000000000000000000000000000         '32 bit value    
PollIO                                                'Turn off solenoids ASAP, if any. In case of random boot state

soundload[3] := 46                                      'Set ".wav" extension once and then forget it!
soundload[4] := 119
soundload[5] := 97
soundload[6] := 118
 
fr.static(string("BPP;V0:75"),0)  
Pause(40) 

PollIO
if View(Sense1,0)                                      'Hold COIN INSERT upon boot to erase high score 
  e.Initialize(28)                                   
  e.WriteLong(28, $A0, 65532, 0)
  fr.scroll(string("HS;CLEAR"),1_000_000)                                                 
  Pause(40)  

music.mountsd
fr.static(string("MUSIC"),0)                                                    
Pause(20)
mountsd  
fr.static(string("SOUND"),0)
Pause(20)

repeat
                                                        'RESET BOARD MECHANICAL CONDITION
  fr.static(string(";"),0)

  GateOpen                                              'Open Titanic Gate
  TrapClose                                             'Close torpedo loader

  repeat while View(Sense1, 30) == 0                                   'until limit switch is hit
    MotorCW(3)
                       
  MotorStop(3)
  
  LEDgun := 0
  Interrupt := 0
  
  repeat
    if View(sense,13) == 0                              'Kick out any and all balls sitting in the drain
      quit
    KickCapture(6)
    Pause(40)
    PollIO

  CheckCaptures(1)                                      '1 indicates to wait for drain load each time so they don't pile up
  ResetDropTargets
  'ATTRACT MODE
  'Check High Score Here
  e.Initialize(28)                                      'High Score Module
  Highscore := e.ReadLong(28, $A0, 65532)               'High Score Module  
  
  repeat while credit == 0                                                                                 
    PollIO
    bored += 1
    if bored == 1
      fr.static(string("INSERT;COIN"),0)
    if bored == 500
      fr.static(string("BILL"),0)   
    if bored == 700
      fr.static(string("PAXTON"),0)
    if bored == 900
      fr.static(string("PINBALL"),0)
    if bored == 1200
      fr.static(string("HIGH;SCORE:"),0)
    if bored == 1500
      fr.score(HighScore,8)
    if bored > 1800 
      bored := 0

    if View(Sense1,0) == 0 
      g := 0
    if View(Sense1,0) and g == 0
      soundloop(99,5,1,255)  
      credit += 1
      Players := 1
      g := 1

  'Wait for Start Mode

  repeat while View(Sense1, 1)  == 0                    'Wait for Start to be pushed

    bored += 1
    if bored == 1
      fr.static(string("PRESS;START"),0)
    if bored == 200
      fr.static(string("TO;PLAY"),0)
    if bored == 400
      if players == 1
        fr.static(string("1;PLAYER"),0)
      if players == 2
        fr.static(string("2;PLAYERS"),0)
      if players == 3
        fr.static(string("3;PLAYERS"),0)
      if players == 4
        fr.static(string("4;PLAYERS"),0)
    if bored > 600
      bored := 0 
    PollIO
    if View(Sense1,0) == 0
      g := 0    
    if View(Sense1,0) and g == 0
      credit += credit + 1
      g := 1
      Players := Players + 1
      bored := 399
      if Players == 5
        players := 4
        Soundloop(99,4,16,255)
      else
        Soundloop(99,4,25,255)    
      PlayerScore[Players] := 0

  Credit -= Players
  CurrentPlayer := 1
 
  'START GAME
  'Note: Drop target info is cleared by "Reset Drop Targets" above, so we don't repeat it here.
    
  'Reset all variables
  Aliencount := 0
  Alienmusic := 0
  Apollo := 0
  Ball := 1
  Blinkcount := 0
  Bored := 0
  BoredDisplay := 0
  Bumpercount := 0
  Can := 0  
  Capture := 0  
  ChaseCount := 1                                       'Bit # of chase
  ChaseSpeed := 40                                      'This decrements as the game progresses to make it seem more intense.
  ChaseBit := 0
  Curtis := 0 
  Demoncount := 0 
  Drain := 1
  FishSung := 0
  Killer := 0                                           'Set 0 means no Club Dread drop target killer 
  Mode := 0
  ModeTimed := 0
  ModeSuggest := 0
  Multiball := 0
  Safehouse := 0
  Score := 0
  SkillShotNum := 4
  SlingCount := 0
  SlingShot := 0  
  Soundwait := 0
  StatusType := 0
  Targetcount := 0
  TheSun := 0
  Titanic := 0
  TitanicMaze := 0

  
  Solenoid := Change(Solenoid, 0, 1)                    'Enables flippers 
  
  StartRandomMusic                                      'Start some music

  Chase0 := %00001001000000000000000000000000           'Set initial chase lights
  Chase1 := %00000000000000000000000000001001
     
  Wait4Shot                                             'Load ball and wait for shot
  
  ModeLaunchSound                                       'Say some random crap 

  ScoreLoop(16)                                         'Get a big fat ZERO on the screen!

  repeat while ball <> 4                                'Main game loop. Return Ball=4 from drain sub to end game and return to attract or credit mode
    PollIO

    if View(Sense,0)                                    'Always check for more credits!  
      credit += 1
    
    if Save
      Save -= 1
      if save == 0
        Light0 := Change(Light0, 0, 0)  

    repeat g from 0 to 1                                'Check if Slings is enabled, decrement value, turn off solenoid when it hits 0
      if Sling[g]
        Sling[g] -= 1
        if Sling[g] == 30
          Solenoid := Change(Solenoid, g + 1, 0)
          Light1 := Change(Light1, g + 21, 0)

    repeat g from 0 to 2                                'Check if Bumpers are enabled, decrement value, turn off solenoids at 10
      if bumper[g]                                       
        bumper[g] -= 1
        if bumper[g] == 10
          Solenoid := Change(Solenoid, g + 3, 0)
          Light0 := Change(Light0, g + 20, 0)     

    if FishBounce
      FishBounce -= 1

    if FishHeads > 3 and FishSung == 0
      FishSung := 1
      SoundLoop(115,2,2,255)
      COGINIT(1,SingFish,@CogStackD)
      
    if can
      can -= 1
        if can == 1                                     'Turn off solenoid and light.
          Solenoid := Change(Solenoid, 14, 0)
          Light1 := Change(Light1, 6, 0)
          Blink1 := Change(Blink1, 6, 0)                'In case Can Bonus was active
          if mode <> 8                                  'Is it anything other than Club Dread? 
             if Hamms == 4                                 'Drank 4 this round?
                ScoreBonus(string("HAMMS;BUZZED"),50,1_000_000,12,5)
             if Hamms == 8                                 'Drank 4 this round?
                ScoreBonus(string("HAMMS;DRUNK"),50,5_000_000,12,5)
          else                                          'If it IS Club Dread, drinking affects timer...
             Drunk += 1
             if Drunk < 5
                Scrollloop(string("COCONUT;PETES;GETTING;SAUCED<"),750_000,1,3)
             if Drunk == 5
                Scrollloop(string("COCONUT;PETE;GOT;DRUNK;KILLER;WINS<"),1_000_000,1,3)
                DreadEnd                                        

    
    if mode == 10 and demons < 1                        'Did we kill all the demons?
      bumpercount := 0
      Demoncount := 0
      SoundLoop(99,14,1,200)
      Blink1 := Change(Blink1, 31, 0)
      mode := 0
      ScoreBonus(string("DEMONS;DEAD<"),50,10_000_000,12,5)

    if bumpercount and mode <> 10 and mode <> 110
      bumpercount -= 1
      if bumpercount == 2 and Demoncount > 2
        Soundloop(115,1,20,200)
        if display == 0
          COGINIT(1,ShowDemons(Demoncount),@CogStackD)   
      if bumpercount == 1
        Demoncount := 0

    if CanBonus
      CanBonus -= 1
        if CanBonus == 1
          StaticLoop(string("HAMMS;GONE<"),1_000_000,80,5)
          Blink1 := Change(Blink1, 6, 0)
    
    if SkillShotNum > 4
      SkillShotNum -= 1          

    'Debouncers
    if tilt
      tilt -= 1
    
    if ApolloDebounce
      ApolloDebounce -= 1

    if TrueLiesCounter
      TrueLiesCounter -= 1

    if SubState
      Lightning += 1
        if Lightning == 1000 and Soundwait == 0
          SoundLoop(115,2,3,250)
          Light1 := Change(Light1, 7, 1)                'Make lightning
        if Lightning == 1050
          Light1 := Change(Light1, 7, 0)
          Lightning := 0
      if SubState  == 1
        if View(Sense1, 29) == 1
          MotorStop(3)
          SubState  := 2                                'Slowly send sub back
      if SubState  > 1
        SubCount += 1
        if SubState == 25 and SubCount == 15
          Light1 := Change(Light1, 9, 1)                'Flicker red light
        if SubState == 25 and SubCount == 30
          Light1 := Change(Light1, 9, 0)                'Flicker red light
          SubCount := 0  
        if SubCount == 750                          
          MotorCW(3)                                    'Move sub to the right appx .5 seconds
          SubState += 1                                 'Use this to position sub, making the optosensor I installed totally useless.
          if SubState == 6
             SoundLoop(99,17,2,200)
             Scrollloop(string("U571;IS;ESCAPING<"),1_500_000,1,3)
          elseif SubState == 8
             SoundLoop(99,17,8,150)
             Scrollloop(string("HURRY;UP<<"),1_500_000,1,4)
          else
             AnimatorLoop(4,17,80_00_000,2,1,64,8,64,8,0,4)
             SoundLoop(115,2,5,175)
                                
        if SubCount == 800
          MotorStop(3)                              'Stop sub.
          SubCount := 0
        
      if View(Sense1, 30) == 1 and SubState > 1         'If sub hits the right edge and hasn't just started the mode...
        Solenoid := Change(Solenoid, 31, 0)             'Stop the waves 
        if SubState < 20                                'Did we not hit it?
          Scrollloop(string("U571;GOT;AWAY;WW2;IS;LOST<"),1_000_000,1,5)
          SoundLoop(99,17,5,100)                          '"You're just not ready to take on a command" 
          MotorCCW(1)                                     'Close trap door
          Pause(40)
          MotorStop(1)
        MotorStop(3)                                    'This stuff happens if we won or not (sub mode end)
        SubState := 0
        repeat g from 27 to 29                          'Turn off ramp blinks
          Blink0 := Change(Blink0, g, 0)
          Light1 := Change(Light1, g - 20, 0)           'Turn off all lights   
        ResetSuggest

    if DarkGolf
      DarkGolf -= 1
        
    if Golf
      Golf -= 1
        if golf == 0
          Blink0 := Change(Blink0, 23, 0)
          SoundLoop(115,2,1,50)                       
          Chase0 := Change(Chase0, 24, 0)
          Scrollloop(string("US;OPEN;HAS;ENDED"),1_500_000,1,4)

    if SlingCount                                       'Have the sling targets been hit recently?
      SlingCount -= 1                                   'Decrement timer.
      if SlingCount == 1 and SlingShot > 2              'Did we hit at least 3 slings in succession?
        SlingBonus                                      'This routine will do things based off what mode we're in
    
    if Inlane
      Inlane -= 1

    if Outlane
      Outlane -= 1

    if SlipStream
      SlipStream -= 1
    
    if TitanicMaze == 255 and display == 0 and soundwait == 0
      TitanicHole

    if TitanicMaze == 254 and display == 0 and soundwait == 0
      TitanicMaze := 0
      Scorebonus(string("TITANIC"),1,10_000_000,8,10)
      TitanicMaze := 253
      Blink0 := Change(Blink0, 30, 0)  
    
    if droptargets == 15 and mode == 1                   'Are all droptargets hit, and mode = Aliens?
      if aliencount <> 1                              'If we are ALREADY in "overtime" do not stop music
        Musicstop
        COGINIT(3,musicloop(4,3),@CogstackM)                       'Aliens music 3           
        soundloop(99,1,8,230)
      if aliencount == 1                                'If we are already IN overtime mode...
        soundloop(99,1,9,230)     
      Aliencount := 1                                 'Aliens mode OVERTIME pointer
      Scorebonus(string(";"),1,((bulletleft*100) + bulletright) * 1000  ,8,10)
         
    if droptargets == 15 and mode <> 1                  'Are all droptargets hit, and mode <> Aliens?
      if mode == 2                                      'CHANGE THIS PROBABLY!!!!
        capture := 0                                    'If we were in Big Love mode, this allows the balls to be captured again 
      mode := 1                                         'Set mode to ALIENS (=1)
      Aliencount := 2

    if Apollo == 6 and Display == 0                     'If we beat Apollo mode, wait til display is clear, then do bonus and reset mode.
      Apollo := 0 
      DeblinkApollo
      Soundloop(115,1,16,230)
      Scorebonus(string("APOLLO;13"),60,13_000_130,12,5)
      repeat g from 23 to 28
        Light1 := Change(Light1, g, 0)

    if TheSun
      TheSun -= 1
      if TheSun == 200                                  'Halfway there?
        Light1 := Change(Light1, 10, 0) 
      if TheSun == 1
        TheSun := 400
        Light1 := Change(Light1, 10, 1)

    if Killer                                           'Club Dread sub mode?
      if Blinkcount == 0
        Killer += 1
          if Killer > 19
             Killer := 16
             Light0 := Change(Light0, 19, 0)            'Erase previous killer light
          else
             Light0 := Change(Light0, Killer - 1, 0)    'Erase previous killer light 
        Light0 := Change(Light0, Killer, 1)             'Light current killer light                

      
    if mode == 1                                        'Are we in Aliens mode?
      Aliens                                            'Visit Aliens mode method

    if mode == 0 and ModeSuggest == 0 and display == 0 and soundwait == 0 'and SubState == 0       'Nothing going on?
      BoredMode += 1                                                                'Count timer (appx 4 seconds)
      if BoredMode == 1000                                                          'Then suggest a mode!
        GetModeSuggest

    if mode <> 0 and display == 0                        'If mode active but not much going on...
      BoredDisplay += 1
      if BoredDisplay > 1000                            'Then suggest a mode!
        BoredDisplay := 0
        StatusDisplay      
    
    if ModeSuggest and ModeTimed                         'Have we suggested a mode and is it timer-based?

      BoredMode += 1                                    'If so, increment BoredMode    
      if BoredMode == (ModeTimed / 2)                   'Mid point of timed mode suggestions? Then do stuff to hurry them up!
        if ModeSuggest == 10                            'Demon hunt sub mode?
          Soundloop(99,14,3,150)
          Scrollloop(string("DEMONS;ESCAPING"),1_250_000,1,4)                         
        if ModeSuggest == 14                            'Weird Science sub mode?
          Soundloop(99,3,3,150)                          
          Scrollloop(string("HURRY;WYATT;CREATED;A;WOMAN"),1_250_000,1,4)
        if ModeSuggest == 15                            'Club Dread sub mode?
          Soundloop(99,2,5,150)                          
          Scrollloop(string("KILLER;STILL;AT;LARGE"),1_250_000,1,4)
        'MORE....  
        'MORE....        
      if BoredMode > ModeTimed                         'Time's up, runt. Mode suggest / bonus is ovah. (Charles Bronson voice)
        BoredMode := 0
        KillModeSuggest

    if display == 0 and soundwait == 0                  'This needs work still, I think. Or just mode modes  
      RandomBored += 1
      if RandomBored == 2000
        RandomBored := 0
        RandomSuggestion 
                                 
    CheckSensors                                      'Checks for solenoid-reaction targets, ie, pop bumpers and sling targets

    if droptargets < 15                                 'If drop targets aren't all down...
      CheckDropTarget                                   'Check them and compare to mode.

    if View(Sense, 13)
      balldrain                                         'Check this last so if Ball=4, upon ABORT return we get sent to the Game Over section without any other operations.

    
  'GAME OVER SUBROUTINE (man)
      
  Solenoid := 0                                         'Turn off all solenoids, including flipper control    

  Musicstop

  fr.static(string("GAME;OVER"),0)
  Light0 := 0                                           'Turn off all lights
  Light1 := 0
  Chase0 := 0
  Chase1 := 0
  Blink0 := 0
  Blink1 := 0
  PollIO   
  SoundPlay(99,1,18) 
  if players == 1
      ScoreLoop(8)
      SoundPlay(115,1,3)
  if players > 1                                        'In MP, see who got the best score and display them.
    fr.static(string("WINNER:"),0)
    Pause(80) 
    if PlayerScore[1] > PlayerScore[2] and PlayerScore[1] > PlayerScore[3] and PlayerScore[1] > PlayerScore[4]
      Score := PlayerScore[1]
      CurrentPlayer := 1
    if PlayerScore[2] > PlayerScore[1] and PlayerScore[2] > PlayerScore[3] and PlayerScore[2] > PlayerScore[4]  
      Score := PlayerScore[2]
      CurrentPlayer := 2   
    if PlayerScore[3] > PlayerScore[1] and PlayerScore[3] > PlayerScore[2] and PlayerScore[3] > PlayerScore[4]  
      Score := PlayerScore[3]
      CurrentPlayer := 3 
    if PlayerScore[4] > PlayerScore[1] and PlayerScore[4] > PlayerScore[2] and PlayerScore[4] > PlayerScore[3]  
      Score := PlayerScore[4]
      CurrentPlayer := 4 
    ShowPlayer                                          'Display who won
    SoundPlay(115,1,3)
    ScoreLoop(8)
    SoundPlay(115,1,3)
  if score > Highscore
    Pause(40)     
    e.Initialize(28)                                    'High Score Module
    e.WriteLong(28, $A0, 65532, score)                 'High Score Module
    SoundLoop(99,11,3,255)
    fr.scroll(string("NEW;HIGH;SCORE<"),1_500_000)        
  Pause(80)     
  Match(string(";@00@;;@00@;"))



PUB Match(letter) | div, i

i := 0

Soundloop(99,3,22,255)

repeat g from 0 to 11                                 'Put letters in the new variable Filename, so they're easier to modify in a second
  dstring[i++] := byte[letter++]

fr.static(string("MATCH"),0) 

div := 100_000_000                                  
repeat 7                                                'Reduce score to last 2 digits
  Pause(7)                                                
  if (score => div)                                   
    score //= div                                     
  div /= 10    

score /= 10
Pause(20)

g := (||?cnt // 50) + 50
i := 0
div := 2_000_000
 
repeat g
  i += 1  
  if i == 10
    i := 0
  dstring[2] := score + 48
  dstring[8] := i + 48
  fr.static(@dstring,0)
  waitcnt(div + cnt)
  div += 50_000

Pause(40)

if score == i
  fr.static(string("FREE;GAME<"),0)
  Credit += Players
  repeat while soundwait <> 0
  soundplay(99,12,1) 
else
  Pause(60) 





'----------------------------------------------GAME MODES-----------------------------------------------------------  
PUB RandomSuggestion | what                                    'These are note modes per se, just random stuff to do

What := ||?cnt // 5              
What += 1                       'From 1-5 (hopefully)

What := 1                       'Set to test

if what == 1 and CanBonus == 0
  StaticLoop(string("HAMMS;LIT"),500_000,80,8)
  CanBonus := 5000
  Blink1 := Change(Blink1, 6, 1)

if what == 1 and CanBonus
  What := 6

  
    

PUB GetModeSuggest              'After inactivity, the machine "suggests" a mode and awards a bonus if done
                                'ModeSuggest is what it picks. When a mode starts, it can see if it was suggested and give a bonus
                                'ModeTimed indicates if the mode has a timed shelf life. If so, ModeTimed = kernel cycles before it ends

ModeSuggest := ||?cnt // 7 
ModeSuggest += 9

'ModeSuggest := 13                                             'Set to test
ModeTimed := 0                                          'Default

if ModeSuggest == 9
  Soundloop(99,4,10,200)
  Scrollloop(string("WOO;JAMIE;LEE;CURTIS"),1_500_000,1,9)
  GateOpen
  Chase0 := Change(Chase0, 5, 1)                               'Chase Curtis lights
  Blink0 := Change(Blink0, 30, 1)                              'Blink Ramp Light
  GateClose
  ModeTimed := 6_000
  
if ModeSuggest == 10                                           'If DEMON HUNT
  Soundloop(99,14,6,200) 
  Scrollloop(string("KILL;6;DEMONS"),1_500_000,1,9)
  Blink1 := Change(Blink1, 31, 1)
  Demons := 6
  ModeTimed := 9_000                                                

if ModeSuggest == 11
    Soundloop(99,5,8,200)
    Scrollloop(string("TITANIC;DIVE;READY"),1_500_000,1,9)
    GateClose                                                                   'This'll get their attention!
    GateOpen
    Blink0 := Change(Blink0, 30, 1)
    ModeTimed := 6_000

if ModeSuggest == 12
  ModeTimed := 7_000
  if apollo == 0
    Scrollloop(string("LAUNCH;WINDOW;OPEN"),1_500_000,1,9)
    Soundloop(99,13,7,200)  
  else
    Scrollloop(string("HELP;APOLLO;13"),1_500_000,1,9)
    Soundloop(99,13,8,200)         
  Blink0 := Change(Blink0, 4, 1) 

if ModeSuggest == 13
  Scrollloop(string("DESTROY;U571"),1_500_000,1,9)
  'Add light blinkers to right ramp
  Light1 := Change(Light1, 8, 1)                        'Light up periscope
  TrapOpen                                              'Open trap door
  MotorCCW(3)                                           'Start moving sub out
  SoundLoop(99,17,7,200) 
  SubState := 1
  Chase0 := Change(Chase0, 27, 0)                       'Stop F1-F3 chase lights.
  repeat g from 27 to 29                                'Make the right ramp lights all blink for shot indicator
    Blink0 := Change(Blink0, g, 1)

if ModeSuggest == 14
  Scrollloop(string("HIT;DROP;TARGETS;TO;PROTECT;WYATTS;VIRGINITY"),1_000_000,1,9)
  ResetDropTargets
  BlinkDrops(1)                                         'Blink drop targets
  Light0 := Change(Light0, 10, 1)                       'Light Greasy Pork Sandwich
  Mode := 7                                             'Set Mode to 7
  COGINIT(3,musicloop(9,1),@CogstackM)                  'Weird Science music
  SoundLoop(99,3,7,200) 
  ModeTimed := 10_000

if ModeSuggest == 15
  Scrollloop(string("CATCH;KILLER;BEFORE;PETE;GETS;DRUNK"),1_000_000,1,9)
  ResetDropTargets
  Light0 := Change(Light0, 9, 1)                        'Light Club Dread sign
  Mode := 8
  Killer := 18                                          'Killer light starting position
  Drunk := 0                                            'If Pete drinks 5 beers he's done!
  COGINIT(3,musicloop(7,2),@CogstackM)                  'Pleasure Island song
  SoundLoop(99,2,6,250)
  


PUB KillModeSuggest

if ModeSuggest == 9
  Soundloop(99,4,14,50)
  Scrollloop(string("CURTIS;GOT;AWAY"),1_500_000,1,9)
  Chase0 := Change(Chase0, 5, 0)                               'Chase Curtis lights
  Blink0 := Change(Blink0, 30, 0)                              'Blink Ramp Light

if ModeSuggest == 10
  Scrollloop(string("DEMONIC;OVERRUN"),1_000_000,1,9)
  Soundloop(99,14,2,50)  
  Blink1 := Change(Blink1, 31, 0)

if ModeSuggest == 11
  Scrollloop(string("SUB;LAUNCH;DELAYED"),1_000_000,1,9)
  Blink0 := Change(Blink0, 30, 0)
  
if ModeSuggest == 12
  Blink0 := Change(Blink0, 4, 0) 
  if apollo == 0
    Scrollloop(string("LAUNCH;WINDOW;MISSED"),1_500_000,1,9)
    if soundwait == 0
      Soundloop(99,13,10,50)    
  if apollo
    Scrollloop(string("APOLLO;OUT;OF;RANGE"),1_500_000,1,9)     
    if soundwait == 0
      Soundloop(99,13,9,50) 

if ModeSuggest == 14
  Scrollloop(string("WYATT;GOT;LAID;CHET;FAILED<"),1_250_000,1,9)
  Light0 := Change(Light0, 10, 0)                       'Light Greasy Pork Sandwich
  SoundLoop(99,3,14,250)
  BlinkDrops(0)                                         'Turn off blinking drop targets

  if mode == 8                                          'As long as a different mode didn't start in the meantime...
    Mode := 0                                           'Back to No Mode, new music
    StartRandomMusic     
    ResetDropTargets 
   

ResetSuggest


PUB ResetSuggest

ModeSuggest := 0    
ModeTimed := 0
BoredMode := 0



PUB Aliens

if aliencount == 2                                      'Did mode just start? (IE, we aren't in WIN mode)

  SoundLoop(99,1,7,255)                                 '"Hudson, run a bypass!"
  Light0 := Change(Light0, 13, 1)                         'Light up ALIENS MODE light
  BlinkDrops(1)
  COGINIT(3,musicloop(4,1),@CogstackM)                       'Aliens music 1         
  Guncount := 0

  Bulletleft := 0
  Bulletright := 0
  Scrollloop(string("CLEAR;DROP;TARGETS;BEFORE;BULLETS;RUN;OUT<"),1_000_000,1,10)
  
  repeat 95                                             'Number of bullets the M41A rifles held in Aliens
    Bulletleft += 1
    Bulletright += 1
    Showbullets((bulletleft*100) + bulletright)
    PollIO
    
  Bulletsub := 0
  Aliencount := 3                                     'Start Alien Mode counter
  alientarget := ||?cnt // 100
  alientarget += 400                                    'Start randomizer for sentry gun firing

if targetcount == 2 and alienmusic == 0
  COGINIT(3,musicloop(4,2),@CogstackM)                       'Aliens music 2
  Alienmusic := 1
    
if droptargets > 14                                 'Are droptargets all up?
  droptargets := droptargets + 1                    'If so, increase value for timer
  if droptargets == 230                             
    Solenoid := Change(Solenoid, 7, 1)              'Reset drop targets
  if droptargets == 250
    droptargets := 0
    Solenoid := Change(Solenoid, 7, 0)              'Release drop targets solenoid
    Targetcount := 0

if Aliencount > 2
  if soundwait == 0
    aliencount += 1

if aliencount == alientarget
  AnimatorLoop(4,0,3_000_000,255,1,74,8,64,8,1,8) 
  RandomAlienGun
  aliencount := 3
  alientarget := ||?cnt // 200
  alientarget += 200

if guncount
  bulletsub += 1
    if bulletsub == 7                                   'How quickly we use bullets. (kernel cycles)
      bulletsub := 0
        if guncount < 20 and bulletleft
          bulletleft -= 1
          if bulletleft == 50
                                bulletflag := 10
        if guncount > 19 and bulletright
          bulletright -= 1
          if bulletright == 50
                                bulletflag := 23
      Showbullets((bulletleft*100) + bulletright)


if bulletleft == 0 and bulletright == 0
  if aliencount == 1
    score := score + 10_000_000
    Scrollloop(string("WELL;DONE;MARINES<"),1_000_000,1,8)
    SoundLoop(99,1,17,255)           
  else
    Scrollloop(string("XENOMORPHS;WIN"),1_000_000,1,7)
    SoundLoop(99,1,11,255)  

  EndAliens
  StartRandomMusic
  


PUB ShowBullets(scorex) | div, z_pad, temp

div := 1_000
z_pad := 0                                               'clear zero-pad flag
LEDgun := 0
    
  repeat 4
    LEDgun <<= 8
    if (scorex => div)                                   ' printable character?
      temp := (scorex / div)                             'yes, print ASCII digit
      scorex //= div                                     'update value
      z_pad~~
    else'if z_pad or (div == 1)                          'printing or last column?
        temp := 0 
    LEDgun += SEG7LED[temp]
    div /= 10



PUB RandomAlienGun | clip

clip := ||?cnt // 4

clip +=  8
COGINIT(2,Gunloop(clip),@CogstackS) 

  
PUB Gunloop(clip) | gtemp

soundwait := 1
interrupt := 1
Guncount := ||?cnt // 30
Guncount += Guncount + 1
if guncount < 20 and bulletleft == 0                    'If it wants to decrement LEFT bullets but none are left...
  guncount := 30                                        'set it to RIGHT bullets
if guncount > 19 and bulletright == 0                   'And vice-versa
  guncount := 10    
SoundPlay(115,1,clip)
if display == 2
  DisplayStop
Guncount := 0  
if aliencount <> 1
  if guncount < 20
    gtemp := 19  
  else
    gtemp := 22
  if bulletflag
    gtemp := bulletflag
    bulletflag := 0
  if bulletleft < 30 and bulletright < 30
    gtemp := 26
    StaticLoop(string("GUN;CRITICAL"),1_000_000,60,5)
  else
    Scoreloop(16)
       
  SoundPlay(99,1,gtemp)
     
Interrupt := 0                                          'Cog will self-terminate, unlike Arnold


PUB EndAliens

'End Aliens mode
if mode == 1
  mode := 0
aliencount := 0
LEDgun := 0
ResetDropTargets
BlinkDrops(0) 
Alienmusic := 0
Light0 := Change(Light0, 13, 0)


PUB BigLoveBall(str_addr)

MotorStop(3)                                            'If sub was moving, stop it
KillWaves
repeat while display                                    'Let any animations finish before we display text

'SoundStop
if capture < 7                                          'If Capture isn't yet 7 just marry 1 wife. 
  Scrollloop(str_addr,1_000_000,0,10)

if Capture == 10                                         'If Capture = 7 then start Big Love Mode!
  Light0 := Change(Light0, 15, 1)                       'Light up BIG LOVE
  Light0 := Change(Light0, 31, 1)                       'Light up wives
  Light0 := Change(Light0, 23, 1)
  Light0 := Change(Light0, 3, 1)
  PollIO                                                'Show light changes right away

  Save := 0                                             'If somehow a SAVE was active, it isn't anymore.
  Light0 := Change(Light0, 0, 0)                        'Make sure Save light is off
  MusicStop                                             'Stop any current music...
  AnimatorLoop(4,7,20_000_000,9,0,52,8,64,8,1,255)      'Run animation (add 2 wives to it DAMMIT)
  SoundPlay(115,1,26)                                   'Serially play sound. Once it is over... 
  COGINIT(3,musicloop(5,2),@CogstackM)                  'new music, and BIG LOVE mode starts.
  if mode == 0
    Mode := 2                                           'Mode 2 is Big Love Multiball mode
  Multiball := 3                                        'Change to 3 once we have all 3 ball locks in
  CheckCaptures(0)                                      'Kicks out the balls   
  SoundLoop(99,11,4,255)                                '"Ok let's party!"  
  fr.static(string(";"),0) 
  fr.static(string("BIG;LOVE<"),0)
  ResumeStates                                          'If the sub was going, let it restart
  return                                                'Bounce back to the main loop

SoundLoop(99,4,23,255)

repeat while display <> 0                               'Wait for scroll to finish

Scorebonus(string(";"),1,1_000_000,8,5)

if multiball                                            'Is this the last ball of a multiball?
  multiball := 0                                        'Then multiball is zero, done.

LoadBall                                                'Load new ball into shooter lane

g := 1
repeat while g == 1                                     'Similar to Wait4Shot
  PollIO
  g := View(Sense, 2)
  bored += 1
  
  if bored == 1
    fr.static(string("SHOOT;BALL"),0)  
  if bored == 400
    fr.static(string("MARRY;ALL;3"),0)
  if bored == 600
    fr.static(string("TO;MULTIBALL"),0)   
  if bored == 800
    ShowPlayer   
  if bored == 1000  
    bored := 0 

Save := 1_500
Light0 := Change(Light0, 0, 1)

Scoreloop(16)                                           'Eventually randomize 5 sayings for possible wife bitwise combos
if capture < 4                                          'Play a sexist sound quote
  Soundloop(99,4,13,175)   
if capture > 3 
  Soundloop(99,4,18,175)

ResumeStates


PUB Apollo13

Apollo += 1
Light0 := Change(Light0, 14, 1)                         'Light up APOLLO 13 mode
Blink0 := Change(Blink0, 1, 1)                          'Make oxygen tanks blink
Blink0 := Change(Blink0, 2, 1)
Light1 := Change(Light1, Apollo + 21, 0)                'Mission progress light OLD
Light1 := Change(Light1, Apollo + 22, 1)                'Mission progress light NEW  

g := (Apollo - 1) * 7

if ModeSuggest == 12
  ModeSuggest := 0
  Bored := 0
  Blink0 := Change(Blink0, 4, 0) 
  score += 100_000
  PAUSE(30)   

Soundloop(99,13,Apollo,251)

AnimatorLoop(4,Apollo,ApolloData[g] * 1_000_000,ApolloData[g + 1],1,ApolloData[g + 2],ApolloData[g + 3],ApolloData[g + 4],ApolloData[g + 5],ApolloData[g + 6],9)


PUB DeblinkApollo

Blink0 := Change(Blink0, 1, 0)
Blink0 := Change(Blink0, 2, 0) 
Light0 := Change(Light0, 14, 0)


PUB TitanicEnter                                        'Enter the Titanic
                                                        'Titanic # will be 0-4 here, never 5

if ModeSuggest == 11                                     'Did the CPU suggest this mode?
  ModeSuggest := 0                                      'Reset mode suggest
  Score += 2_000_000                                    'Give bonus!

if mode == 0 or mode == 7 or mode == 8                  'If no active mode, or if drop target-based sub mode
  mode := 4                                             'Set Titanic Mode. Can happen during Titanic mission

if Titanic == 0 and ModeSuggest <> 14 and Killer == 0 and mode <> 1  'First time we hit this and nothing else using drop targets?
  ResetDropTargets
  BlinkDrops(1)                                            'Set drop targets to blink

TitanicMaze := 1
Chase1 := Change(Chase1, 11, 1)

if titanic < 3
  AnimatorLoop(4,13,17_000_000,3,1,64,8,64,8,0,7)       'Run animations based off how many segments we've found.
if titanic > 2 and titanic < 5 
  AnimatorLoop(4,14,2_000_000,17,1,127,8,0,8,2,7)

Soundloop(99,5,TitanicIn[Titanic],210)                  'Play sound clip


if mode == 4
  COGINIT(3,musicloop(2,Titanic + 2),@CogstackM)        'If in full mode, play music


PUB TitanicExit(hole)                                   'Check which hole we got and score accordingly

Blink0 := Change(Blink0, 30, 1)                         'Make ramp light blink
TitanicMaze := 255  
Titanic += Hole                                         'Score 1 for outer holes, 2 for inner
if titanic > 4
  titanic := 5

repeat g from 16 to 15+Titanic                          'Rake across light in case we got a +2 skip one
  Light1 := Change(Light1, g, 1)


PUB TitanicHole

TitanicMaze := 0                                        'We come here once the animation is done.
 
COGSTOP(1)

if titanic == 5                                         'A winner is you!
  AnimatorLoop(4,15,4_000_000,18,1,0,8,127,8,2,10)      'ROV with Diamond
  Soundloop(99,5,3,255)                                 '"It's Payday boys!"
  COGINIT(3,musicloop(2,1),@CogstackM)                  'Celine Dion. Yeah, that's right.
  TitanicMaze := 254                                    'Titanic win condition flag. Overtime mode, next drain kills mode
  GateClose                                         'Close the gate so the next ramp hit is True Lies. Spices things up.   
  ResetDropTargets
  BlinkDrops(0)                                         'Turn off blinks
  if mode := 4
    mode := 0

else

  if titanic == 4
    repeat g from 16 to 19                              
      Light1 := Change(Light1, g, 0)
    repeat g from 16 to 19
      Blink1 := Change(Blink1, g, 1)                      'Make the heart blink
  Soundloop(99,5,TitanicOut[Titanic - 1],210)
  Scorebonus(string("DIAMOND;LIT"),60,(Titanic * 2) * 1_000_000, 6, 5)

  

PUB EndTitanic

TitanicMaze := 0
Titanic := 0
Light0 := Change(Light0, 12, 0)                       'Turn off Titanic Light
Blink0 := Change(Blink0, 30, 0)                       'Turn off Skill Ramp blinker
Chase1 := Change(Chase1, 11, 0)                       'Turn off Titanic Chase Lights
  
repeat g from 16 to 20
  Light1 := Change(Light1, g, 0)
repeat g from 16 to 20
  Blink1 := Change(Blink1, g, 0)
  
PollIO
 

PUB TrueLies

Light0 := Change(Light0, 11, 1)                         'Turn on TRUE LIES light

if mode <> 4                                            'If we're not in Titanic Mode...   
  GateClose                                             '...then close the gate so we can pursue this mode.

if mode == 0                                            'If no mode                                            
  mode := 3                                             'Enter True Lies mode officially and...

if ModeSuggest == 9                                     'Did the CPU suggest this mode?
  ModeSuggest := 0                                      'Reset mode suggest
  Score += 2_000_000                                    'Give bonus!
  
SoundLoop(99, 4, TrueData[(Curtis * 2) + 1],251)        'Play sound clip based off how far we are
if mode == 3                                            'Change music if we're in the full mode
  COGINIT(3,musicloop(6,TrueData[Curtis * 2]),@CogstackM)    

if Curtis == 0                                          'Did this mode just start?
  Safehouse := 1                                        'Set True Lies safehouse multiplier to 1
  Chase0 := Change(Chase0, 5, 0)                        'Turn off chase lights, if suggested
  
Curtis += 1
if curtis == 5
  Curtis := 4

if curtis < 3
  Blink1 := Change(Blink1, 14, 1)                       'Blink low beams
  AnimatorLoop(4,8,750_000,30,1,127,8,0,8,1,7)
if curtis == 3
  AnimatorLoop(4,10,2_000_000,18,1,64,8,64,8,0,7)
  Blink1 := Change(Blink1, 15, 1)                       'Blink high beams   
if curtis == 4
  AnimatorLoop(4,11,7_000_000,15,1,64,0,64,8,1,7)
  GateOpen                                              'Open gate now so next shot is Titanic. Spices things up a bit
  if mode := 3                                          'If True Lies mode is active...
    mode := 0                                           '...turn it off. The mode light will go off on the next Ball Drain. 
if curtis == 5                                          'Overtime?
  curtis := 4                                           'Reset so the lights won't get fucked up
  Scorebonus(string("JAMIE;LEE"),60,5_000_000,15,7)     'Overtime bonus!   
  
repeat g from 4 to curtis + 4
  Light0 := Change(Light0, g, 1)
score += (1_000_000 * Curtis) * Safehouse                             'Add safehouse multiplier here.    



PUB TorpedoFire | templight

TrapClose                                               'Close trap door. This keeps it from getting stuck.  
MotorStop(3)                                            'Stop any sub movement
SoundLoop(99,17,1,255)                                  'Put in something like FIRE! later...
CogStop(1)
fr.static(string(";"),0)                                'Clear display (maybe do this more often)
Scrollloop(string("TORPEDO;LOADED"),1_000_000,0,10)
g := 0

repeat while g < 500
  PollIO
  g += 1
  if View(Sense,2) == 0
    g := 0
  if View(Sense,8)                                      'For the hyperactive a-holes that hit the ball RIGHT AWAY
    g := 600
  
COGSTOP(1)                                              'End the current scroll loop  
g := 1    
bored := 0
repeat while g == 1                                     'Wait for shot
  PollIO
  g := View(Sense, 2)
  bored += 1
  if bored == 2
    fr.static(string("FIRE<"),0)
  if bored == 100
    fr.static(string(";"),0)   
  if bored == 200
    bored := 0


SoundLoop(115,2,7,255)                                  'Put torpedo sound, German alarm here
AnimatorLoop(4,16,500_000,32,0,0,8,128,8,7,10)              'Torpedo Launch graphics
g := 0

repeat while g == 0
  PollIO
  g := View(Sense,8)

KillWaves
CogStop(1)
Display := 0

if SubState > 8
  StaticLoop(string("MISS<"),0,60,7)
  SoundLoop(115,2,1,150)
  Score += 1_000_000

if SubState < 9                                         'Did we hit it?
  Score += 5_710_000
  SoundLoop(115,2,4,255)                                'Boom!
  repeat g from 7 to 9                                  'Briefly light all periscope bulbs. (Well, technically they are LED's.)
    Light1 := Change(Light1, g, 1)
  PollIO
  AnimatorRun(4,18,4_000_000,1,0,64,8,64,8,0)           '1 cycle of explosion
  StaticLoop(string("U571;HIT<"),0,90,7)
  repeat g from 7 to 8                                  'Turn off white and green lights
    Light1 := Change(Light1, g, 0)
  SubState := 25                                        'Flag to put it back since it's been hit   
  MotorCW(3)                                            'Start putting it back
  SubCount := 0                                         'Make sure we'll be on the new subcount schedule



PUB DreadEnd

Light0 := Change(Light0, 9, 0)                       'Turn off Club Dread sign
Light0 := Change(Light0, Killer, 0)                   'Turn off current Killer light
Killer := 0
ResetDropTargets
if mode == 8
  Mode := 0                                             'Back to No Mode
  StartRandomMusic  




'----------------------------------------------SENSOR CHECK / SCORING / MODE CONTROL-----------------------------------------------------------
  
PUB CheckSensors | type                                 'Check all sensors, except for drop targets which we do elsewhere

Type := 0

if View(Sense1, 3) and Tilt == 0                        'Did player tilt, but only once?
  Tilt := 600
  StaticLoop(string("WARNING"),0,80,10)                'Warn them!
  SoundLoop(99,3,17,255)

if View(Sense1, 3) and Tilt > 0 and Tilt < 400          'Did player tilt with reckless abandon?
  StaticLoop(string("TILT"),0,80,10)                    'Tilt!
  Tilt := 0
  Save := 0
  SoundLoop(99,3,5,255)
  Solenoid := 0                                         'Kill ALL solenoids including flipper control
  repeat while View(Sense, 13) == 0                     'Do nothing until ball drains
    PollIO  

if Capture == 10                                        'If in BIG LOVE mode, kick out any balls that go into locks.
  repeat g from 9 to 11                                 'We use "capture" instead of "mode" here in case mode changes during multiball
    if View(Sense,g+7)
      KickCapture(g)

if capture <> 10                                        'If we're not in Big Love mode, look for captures

  if View(Sense, 16) and View(Capture, 0) == 0          'Ball in Jeane Tripplehorn lock for 1st time?
    Capture += 1                                        'Set first bit of capture (0) to 1
    Blink0 := Change(Blink0, 31, 0)                     'Turn off Jeanne Tripplehorn's blink (whether it was on or not)
    if View(Capture, 1) == 0                            'Did we get Chloe yet?
      Blink0 := Change(Blink0, 3, 1)                    'If not, make her blink so we know to shoot there next
    elseif View(Capture, 1) == 1
      Blink0 := Change(Blink0, 23, 1)                   'If we got her too, only Ginnnifer Goodwin left, so make her blink    
    BigLoveBall(string("JEANNE;TRIPPLEHORN;MARRIED"))   'Goto Big Love Mode

    
  if View(Sense, 17) and View(Capture,1) == 0           'Ball in Chloe Sevingy lock for 1st time?  
    Capture += 2                                        'Set second bit of capture (1) to 1
    Blink0 := Change(Blink0, 3, 0)                      'Turn off Chloe's blink (whether it was on or not) 
    if View(Capture, 0) == 0                            'Did we get Jeanne yet? 
      Blink0 := Change(Blink0, 31, 1)                   'Make Jeanne Tripplehorn blink if her ball isn't locked    
    elseif View(Capture, 0) == 1
      Blink0 := Change(Blink0, 23, 1)                   'If we got her too, only Ginnnifer Goodwin left, so make her blink 
    BigLoveBall(string("CHLOE;SEVINGY;MARRIED"))        'Goto Big Love Mode 


  if View(Sense, 18) and View(Capture,2) == 0           'Ball in Wife 3 lock?
    MotorStop(3)                                        'No matter what it's going to pause, so...
    KillWaves                                            'Stop the evil waves
    if capture == 3                                     'Are other 2 wives ready?
      Capture := 10                                     'Set Capture to 10 (Big Love Mode)
      Blink0 := Change(Blink0, 23, 0)                   'Turn off Ginnifer's blink      
      BigLoveBall(string(";"))                          'Goto Big Love mode, it will see the "10" and start mode
    elseif golf
      SoundLoop(115,1,25,142)     
      Blink0 := Change(Blink0, 23, 0)
      Scorebonus(string("NICE;SHOT<"),60, 4_000_000, 6, 5)
      Pause(40)      
      KickCapture(11)
      Golf := 0

    else                                                'If not golf or 3rd wife, "Foreplay"
      SoundLoop(99,4,7,142)
      StaticLoop(string("FOREPLAY<"),0,60,6)       
      foreplay += 1
      Chase0 := Change(Chase0, 24, 0)
        if foreplay == 3
          g := 4_000_000
          repeat g from 24 to 26
             Light0 := Change(Light0, g, 0)             'Turn off lights
             Blink0 := Change(Blink0, g, 1)             'Turn ON blinks
        elseif foreplay == 4
          foreplay := 0
          g := 8_000_000
          repeat g from 24 to 26
             Blink0 := Change(Blink0, g, 0)             'Turn OFF blinks                            
        else
          g := 500_000
          Light0 := Change(Light0, 27 - Foreplay, 1)
      if mode := 4                                      'if in True Lies mode...
        g *= 2                                      'Multiply bonus by 2!
      Pause(90)                                         'We do a manual PAUSE here so the ball ejects during phrase
      Scorebonus(string(";"),1, g, 6, 5)
      KickCapture(11)
    ResumeStates


if View(Sense,2) and SubState                           'Did the ball go back down the shooter lane whilt in Sub mode?
  TorpedoFire                                           'Let player launch torpedo!

if save                                                 'Look for skill shots within the first few seconds
  repeat g from 28 to 30
    if View(Sense,g) and SkillShotNum == 4
      SkillShotNum := 31 - g
      SkillShot

if View(Sense,24) == 0 and TrueLiesCounter == 0         'True Lies ramp
  TrueLiesCounter := 255                                'Set debounce timer.
  TrueLies                                              'Goto True Lies mode and see what to do

if View(Sense,25) == 0 and TitanicMaze == 0             'Titanic Path
  Score += 101_010                                      'Some random points. You're welcome.
  Light0 := Change(Light0, 12, 1)                       'Turn on TITANIC mode light
  TitanicEnter

if TitanicMaze == 1                                     'If we are in the Titanic maze... (prevents debounce)
                                                        '...then check Titanic exit holes.
  if View(Sense,26)                                     'Titanic middle hole
    TitanicExit(2)                                      'Pass value

  if View(Sense,27)                                     'Titanic outer holes
    TitanicExit(1)                                      'Pass value 


if View(Sense,1) == 0                                   'Did we hit the optic sensor on the Right Ramp?
  if SubState                                           'Is the sub crusin' for a brusin'?
    MotorCW(1)                                          'Hold trap door open until the ball hits the plunger.    
    SoundLoop(115,2,8,255)                              'Torpedo loading sound
  else                                                  'If not sub, then it's "A Simple Plan" wheel o' fate.
    Chase0 := Change(Chase0, 27, 1)                     'Chase the F1-F3 lights
    TrapClose                                           'Ensure the trapdoor is closed (vibration MAY open it. Maybe)
    RightRamp := 1                                      'Sets flag for the Inlane Sensor when it comes out.
    SoundLoop(115,2,9,255)                              'Plane Crash!
    AnimatorLoop(4,19,300_000,11,0,128,8,0,8,3,7) 



' START: MULTI-MODE SENSOR ROUTINES.
' Depending on what the active mode is, these sensors do different things.
' Includes: Inlanes, Outlanes, Golf Lane, Slipstream lane

if View(Sense,22) and DarkGolf == 0
  DarkGolf := 255          
  if mode <> 6 and golf < 1900
    SoundLoop(115,1,24,200)
    if capture <> 3
      Blink0 := Change(Blink0, 23, 1)                     'Turn on WIFE 3 blink
      Chase0 := Change(Chase0, 24, 1)                     'Turn on SEX chaser lights
      if golf == 0
        Scrollloop(string("AIM;GOLF;BALL;AT;WIFE;3<"),1_000_000,1,5)
      else
        Scrollloop(string("US;OPEN;EXTENDED<"),1_000_000,1,3)
      Golf := 2000                                          'Set timer to make shot 

  if TheSun                                             'Near Dark mode?
    if TheSun < 200                                     'Is the sun off?
      Scrollloop(string("DAYLIGHT;AVERTED<"),1_000_000,1,5)
      SoundLoop(99,7,2,255)
      Score += (500_000 * NeckBonus)
      NeckBonus += 1                                    'Multiplier for redneck kills
       
    if TheSun > 199                                     'Is the sun on?
      Scrollloop(string("YOU;BURNED;TO;DEATH<"),1_000_000,1,5)
      Light1 := Change(Light1, 10, 0)                   'Turn off the sun   
      TheSun := 0
      SoundLoop(99,7,4,255)
      NeckBonus := 0                                    'Reset neck bonus
      if mode == 6                                      'If nothing else has started...
        mode := 0
        StartRandomMusic


if View(Sense, 23) and SlipStream == 0                  'Ball down Slipstream lane? (Yes, that's what I'm calling it.)
  SlipStream := 255                                     'Set Slipstream lane debounce, regardless of mode

  if mode == 0                                          'No modes active?
    mode := 6                                           'Near Dark mode active
    NeckBonus := 1                                      'Bonus multiplier for dodging sun
    Scrollloop(string("KILL;REDNECKS;AVOID;THE;SUN"),1_000_000,1,8)
    COGINIT(3,musicloop(8,1),@CogstackM)
    TheSun := 2                                         'Timer for sun. 0-200 off, 200-400 on.

  if mode == 3                                          'True Lies mode?
    Score += 500_000
    SoundLoop(99,4,15,200)
    Safehouse += 1                                      'Increase True Lies multiplier  
    Scorebonus(string("SAFEHOUSE"),60, 3_000_000, 6, 5)

  if mode == 1                                          'Aliens mode?
    Score += 1_000_000
    SoundLoop(99,1,21,200)
    BulletLeft += 20                                    'Give extra ammo (up to 95 rounds per gun)
    if BulletLeft > 95
      BulletLeft := 95
    BulletRight += 20
    if BulletRight > 95
      BulletRight := 95
    Showbullets((bulletleft*100) + bulletright)         'Show extra ammo straight away!
    Scorebonus(string("EXTRA;AMMO"),60, 500_000, 6, 5)

  if mode == 4                                          'Titanic Mode?                  
    Score += 50_000

  if mode == 7                                          'Weird Science Mode?
    SoundLoop(99,3,1,200)
    Score += 750_000
  
  
if View(Sense,20) and Inlane == 0                       'Ball down inlane?
  Inlane := 255                                         'Reset inlane debounce

  if RightRamp == 0                                                  'If not the wheel, then it's a normal inlane
    Score += 50_000                                     '50 grand no matter what.
    SoundLoop(99,InLaneQuote[mode * 2], InLaneQuote[(mode * 2) + 1], 200)
 

  if RightRamp                                          'Did we go down the right ramp already?
    CheckWheel                                          'Yes, so check what the wheel landed on.
    if Wheel < 600                                      'Sensor under yellow? (= red wins)
      Scrollloop(string("BILLY;BOB;THORTON;HAS;DIED"),1_000_000,1,5)
      SoundLoop(99,7,7,255)
    if Wheel > 599 and Wheel < 1200                     'Sensor under Green (= yellow wins)
      Scorebonus(string("RANSOM;MONEY"),60, 2_000_000, 6, 5)
      SoundLoop(99,2,4,255)
    if Wheel > 1199 and Wheel < 2000                    'Sensor under Blue? (= green wins)    
      Scorebonus(string("MILL;PAYDAY"),60, 7500, 6, 5)
      SoundLoop(99,12,3,255)                
    if Wheel > 1999                                     'Sensor under Red? (= blue wins) 
      Scorebonus(string("RANSOM;MONEY"),60, 4_000_000, 6, 5)
      SoundLoop(99,2,11,255)  
    RightRamp := 0                                      'If we were on the ramp, we're certainly off now!


if View(Sense,19) and Outlane == 0                      'Ball down outlane?
  Outlane := 255                                        'Reset outlane bounce
  Score += 100_000                                      '100 grand no matter what. We feel sorry for them since it's gonna drain.

  SoundLoop(99,OutLaneQuote[mode * 2], OutLaneQuote[(mode * 2) + 1], 100)

' END: IN AND OUT LANE MULTI-MODE ROUTINES.
 

 
if (View(Sense, 14) or View(Sense, 15)) and ApolloDebounce == 0                 'Apollo Targets Hit?
  if View(Sense,14)
    score +=130_060
  if View(Sense,15)
    score +=65_030
  ApolloDebounce := 255
  if aliencount<>1 and Apollo < 6                                      
    Apollo13
  elseif aliencount == 1 and Apollo < 6
    Score += 20_000
    type := 3

if View(Sense, 21) and FishBounce == 0                  'Fish heads ricochet target
  FishBounce := 100
  FishHeads += 1
  if FishHeads <> 3                                     'At # 3 the fish head sings instead!
    type := 4

if View(Sense, 31) and Can == 0                         'Hamm's ricochet target
  Light1 := Change(Light1, 6, 1)                        'Light can  
  Solenoid := Change(Solenoid, 14, 1)                   'Crush it!
  Can := 50                                             'Set can crush/light timer
  Hamms += 1
  type := 5
  if CanBonus
    ScoreBonus(string("HAMMS;DRANK<"),60,750_000,10,5)
    CanBonus := 0


repeat g from 0 to 1                                    'Set Countdown timer for sling targets release and debounce 
  if View(Sense, g + 3) and Sling[g] == 0 
    Solenoid := Change(Solenoid, g + 1, 1)
    Light1 := Change(Light1, g + 21, 1)
    Sling[g] := 40                                       
    Score += 25_060
    type := 1

repeat g from 0 to 2                                    'Set Countdown timer for bumpers release and debounce 
  if View(Sense, g+ 5) and Bumper[g] == 0 
    Solenoid := Change(Solenoid, g+ 3, 1)
    Light0 := Change(Light0, g+ 20, 1)
    Bumper[g] := 30                                         
    type := 2

if type                                                 'Do scoring and what not based off what got hit (change?)

    if aliencount == 1
      type := 0
      Score += 25_000
      RandomAlienGun
      
    else
    
      if type == 1                                      'Sling hit?
        if mode == 6
          Soundloop(115,1,20,160)
                                  
        else
        
          Soundloop(115,1,1,160)                       'Sniper shots (Navy Seals)
          
        if SlingCount                                   'Is SlingCount above 0? (Has it been less than 2 seconds since last sling?)
          SlingShot += 1                                'Increase count of sling hits.
        SlingCount := 350                               'Set SlingCount for next round.

      if type == 2
        if mode <> 110                                  'If not in "Demon Hunt" completion mode...
          Soundloop(115,1,19,100)                       'Sound for bumper impacts. SLIGHTLY less sound priority than the launch sound  
          DemonCount += 1 
          Bumpercount := 175                                      'Countdown for successive bumper hits
        if mode == 10
          Score += 50_100
          Demons -= 1
          if display == 0
            fr.score(Demons,16)
            
        else
        
          Score += 25_050
                  
      if type == 3
        Soundloop(115,1,18,201)                    'Sound for general target impacts
      if type == 4
        Soundloop(115,1,21,180)                    'Sound for Fish Heads bonus.
      if type == 5
        Soundloop(115,2,6,180)                     'Sound for Hamm's bonus.
      
  if display == 0
    scoreloop(8)                                             'Run Scoreloop last to get sound effect as close to impact as possible


PUB CheckDropTarget | yes

yes := 0                                                'Flag for drop target hit, and which

repeat g from 0 to 3
  if View(Sense, g + 9) and View(DropTargets, g) == 0   'If droptarget hit for the first time...   
    DropTargets := Change(DropTargets, g, 1)            'Set current bit to 1  
    Blink0 := Change(Blink0, g + 16, 0)                 'If light was blinking, turn off the blink. 
    yes := 1
    TargetCount += 1

if yes
  score += (droptargets * 10_210)   

  if mode <> 1 or mode <> 4 or mode <> 7 or mode <> 8                'If no eligible modes present...
    Soundloop(115,1,17,150)                             'Standard drop target hit sound
    Scoreloop(8)

  if mode == 1                                          'If we're in Aliens mode...
    Score += 50_000 
    if targetcount < 4                                  'If it's not the last target
      SoundLoop(115,1,12,210)                           'Drop target sound in Aliens Mode
      Scrollloop(string("@@@;BREAKING;ENCRYPTION;@@@"),700_000,1,7)

  if ModeSuggest == 14                                      'Weird Science Mode?
    score += TargetCount * 50_000
    if TargetCount == 1
      SoundLoop(99,3,6,225)
      Scrollloop(string("PORK;SANDWICH;SERVED<"),1_250_000,1,7)
    if TargetCount == 2
      SoundLoop(99,3,22,225)
      Scrollloop(string("WYATT;COCKBLOCKED<"),1_250_000,1,7)        
    if TargetCount == 3
      SoundLoop(99,3,12,225)
      Scrollloop(string("SHOTGUN;LOADED<"),1_250_000,1,7)
    if TargetCount == 4
      SoundLoop(99,3,8,225)
      Scrollloop(string("WYATTS;VIRGINITY;PRESERVED<"),1_250_000,1,7)
      Light0 := Change(Light0, 10, 0)
      Score += 10_000_000
      ResetSuggest
      Pause(60)
      ResetDropTargets 
      if mode == 7                                      'If we were still in Mode 7...
        mode := 0
    return                                              'Exit out so it won't check Titanic before Weird Science is over

  if killer                                             'Club Dread killer hunt mode?
    if View(DropTargets, Killer - 16) == 1              'Did we catch the killer?
      Scorebonus(string("GOT;KILLER<"),80, 4_000_000, 6, 6) 
      Soundloop(99,2,9,255)                             'Mode win!
      Pause(20)   
      DreadEnd
    else                                                'No, we did hit the right one...
      Scrollloop(string("WRONG;SUSPECT<"),1_000_000,1,7)  
      Soundloop(99,2,10,150)
      Score += 50_000         
      Pause(20)
      ResetDropTargets
    return                                              'Exit out so it won't check Titanic before Club Dread is over 

 
  if mode == 4                                          'Titanic Mode?
    score += TargetCount * 50_000
    if TargetCount == 1
      SoundLoop(115,1,5,225)
      Scrollloop(string("FANCY;PLATE;FOUND"),1_000_000,1,7)
    if TargetCount == 2
      SoundLoop(115,1,5,225)
      Scrollloop(string("HAIR;CLIP;FOUND"),1_000_000,1,7)        
    if TargetCount == 3
      SoundLoop(115,1,5,225)
      Scrollloop(string("ANCIENT;MIRROR;FOUND"),1_000_000,1,7)
    if TargetCount == 4
      SoundLoop(115,1,5,225)
      Scrollloop(string("OLD;DRAWING;FOUND<"),1_000_000,1,7)
      Light0 := Change(Light0, 10, 0)
      Score += 10_000_000
      Pause(60)
      BlinkDrops(1)
      ResetDropTargets


 



        






'----------------------------------------------BALL DRAIN & LAUNCH ROUTINES----------------------------------------------------------- 

PUB Balldrain | clip, needmusic

Needmusic := 0                                          'We don't know if we NeedMusic yet until we check the modes  

if multiball                                          'Check to see if multiball, if this is last ball out, proceed with drain, if not, quit method  

  if mode == 2                                          'If Big Love is still the active mode
    if display == 0 and multiball > 1                   'As long as it's not the last multiball...
      StaticLoop(string("DIVORCE<"),0,60,8)   
    if soundwait == 0
      Soundloop(115,1,15,255) 

  Pause(20)
  KickCapture(6)
  if multiball == 3
    Light0 := Change(Light0, 31, 0)                     'Turn off Wife 1
  if multiball == 2
    Light0 := Change(Light0, 3, 0)                      'Turn off Wife 2
    Capture := 0                                        'Allow ball captures again
    Light0 := Change(Light0, 15, 0)                     'Turn off BIG LOVE since we're out of balls
    StartRandomMusic                                    'New music     
  if multiball == 1                                     'Fail!
    Light0 := Change(Light0, 23, 0)                     'Turn off Wife 3
  MultiBall -= 1
  if multiball                                          'Any balls left?
    return                                              'Yes, return to main loop

MotorStop(3)                                            'Stop any sub movement   
Solenoid := Change(Solenoid, 31, 0)                     'Stop the waves

if save                                                 
  SaveBall
  Return

Chase0Bit := 0
Chase1Bit := 0
drain := 1

PollIO

repeat while display<>0                                 'Allow any animations to finish   
repeat while soundwait<>0                               'Allow any sounds to finish.   
 
if mode == 2                                            'Big Love mode?
  fr.static(string("BALLS;LOST"),0)                     'Balls are plural then.
else
  fr.static(string("BALL;LOST"),0)      
 
'Check to see if any current modes are active and make any changes needed

Solenoid := 1                                           'Turn off all solenoids except flippers (for moral support) 
DeblinkApollo                                           'Turn off blinking Apollo lights for next round  

repeat g from 24 to 26
  Blink0 := Change(Blink0, g, 0)                        'Turn OFF sex blinks
  Light0 := Change(Light0, g, 0)                        'Turn OFF sex blinks
  Foreplay := 0

if curtis == 4                                          'If True Lies mode is in overtime, kill it
  Curtis := 0
  repeat g from 5 to 8
    Light0 := Change(Light0, g, 0)
  Blink1 := Change(Blink1, 15, 0)                       'Kill headlights
  Blink1 := Change(Blink1, 14, 0)
  Light0 := Change(Light0, 11, 0)                       'Kill mode light
  Blink0 := Change(Blink0, 30, 0)                       'Kill ramp light
  if mode == 3
    mode := 0
    Needmusic := 1

if mode == 1 and aliencount == 1                        'Aliens in overtime?
  EndAliens                                             'Then end it.
  Needmusic := 1
  LEDgun := 0

if mode == 2                                            'End of Big Love mode?
  Needmusic := 1                                        'Reset captures, get new music
  Capture := 0
  Mode := 0

if TitanicMaze == 253                                   'Titanic in overtime mode?
  EndTitanic                                            'End it
  Needmusic := 1 

Drain := 2                                              'This "trick" PollIO into letting us change the lights during a drain

repeat g from 0 to 4
  Chase1Bit := DrainBits[g]
  PollIO
  Pause(5)

clip := ||?cnt // 21                                    'Randomly pick a negative Bill Paxton comment. Later we'll group these by movie / game mode.

Soundstop                                               'When running serial sound commands we need this first to kill whatever's playing

SoundPlay(99,DrainQuote[clip * 2], DrainQuote[(clip * 2) + 1])  
 
fr.static(string("HAMMS;DRANK"),0)
SoundPlay(115,1,6)
fr.score(100_000 * Hamms,8)
BonusBoom
score += 100_000 * Hamms

fr.static(string("FISH;HEADS"),0)
SoundPlay(115,1,5)  
fr.score(250_000 * FishHeads,8)
BonusBoom
score += 250_000 * FishHeads

fr.static(string("TOTAL;BONUS"),0)
SoundPlay(115,1,7)
fr.score((250_000 * FishHeads) + (100_000 * Hamms),8)
BonusBoom

Drain := 1
FishHeads := 0                                          'Clear Fish Heads for next shot / player
FishSung := 0                                           'Fish has not sung yet this ball
Hamms := 0                                              'Clear Hamm's for next shot / player

if apollo == 6                                          'If ball failed before "Bonus" was display
  apollo := 0                                           'Kill Apollo mode so we won't see it upon the next shot. Points have already been awarded

PlayerScore[CurrentPlayer] := Score                     'Store SCORE value in current player's variable

CurrentPlayer += 1                                      'Increment to next player
if CurrentPlayer == Players + 1                         'Check for Player # rollover. In single player, this starts at 2.
  CurrentPlayer := 1
  ball += 1                                             'Increment ball on player rollover. Game ends on Ball 4 of last player  
  ChaseSpeed -= 10                                    
Score := PlayerScore[CurrentPlayer]

if ball < 4                                             'If game is not over (man)
  if needmusic
    StartRandomMusic
  KickCapture(6)
  fr.static(string("GET;READY<"),0) 
  if Players > 1
    Soundloop(99,8,2,255)
  Wait4Shot
  ScoreLoop(16)
  ModeLaunchSound
  ResumeStates


PUB Wait4Shot                                           'Cycles the display while player waits to shoot ball

Bored := 0

Solenoid := Change(Solenoid, 0, 1)                      'Enable Flippers
Bumpercount := 2                                        'Stops the Demon message upon next shot. Prob. not required on final board.

PollIO
if View(Sense, 13)
  KickCapture(6)

if Capture
  Pause(Capture * 15)                                     'If fewer balls in trough, give it time before loading shooter lane

LoadBall                                                'Load ball from trough into shooter lane

g := 1
repeat while g == 1

  PollIO
  g := View(Sense, 2)
  Bored += 1
  if Bored == 1
    ShowPlayer
  if Bored == 300
    ShowBalls(0)
  if Bored == 600
    fr.score(score,8)
  if Bored == 900
    fr.static(string("SHOOT;BALL"),0)
  if Bored == 1200
    Bored := 0

Bored := 0
if save == 0
  Save := 1_500
  Light0 := Change(Light0, 0, 1)
Drain := 0                                              'Ball is officially shot!


PUB BonusBoom

SoundLoop(115,1,3,255)
repeat g from 0 to 2
  Chase1Bit := BoomBits[g]
  PollIO
  Pause(5)
Chase1Bit := 0
PollIO
repeat while soundwait == 1


PUB Skillshot

Scorebonus(string("SKILL;SHOT"),50,SkillShotNum * 300_000, 6, 5)
SkillShotNum := 255 


PUB SaveBall

fr.static(string("BALL;SAVED"),0) 
SoundLoop(99,1,4,200)
Pause(80)
KickCapture(6)
Wait4Shot
Soundloop(99,1,13,255)
Scoreloop(16)


PUB LoadBall

Solenoid := Change(Solenoid, 8, 1)                      'Load new ball into plunger

repeat while View(Sense, 2) == 0                        'Wait for it to roll down and hit the switch
  PollIO

Solenoid := Change(Solenoid, 8, 0)                      'Release solenoid
PollIO






'----------------------------------------------GENERAL I/O-----------------------------------------------------------  

PUB Pause(time)

waitcnt((time * 1_000_000) + cnt)


PUB PollIO | temp0, temp1, temp2, temp3

ChaseCount += 1
blinkcount += 1                                                                                                   
if blinkcount == 200
  blinkcount := 0

if SubState > 0 and drain == 0
  MakeWaves

sense := 0
sense1 := 0        
temp0 := Light0
temp1 := Light1
if blinkcount > 100
  temp0 := temp0 | Blink0
  temp1 := temp1 | Blink1
if ChaseCount == ChaseSpeed
  ChaseCount := 1
  Chase0Bit := Chase0
  Chase1Bit := Chase1
  Chase0Bit <<= ChaseBit
  Chase1Bit <<= ChaseBit   
  ChaseBit += 1
  if ChaseBit == 3
    ChaseBit := 0

if drain <> 1
  temp0 := temp0 | Chase0Bit
  temp1 := temp1 | Chase1Bit

temp2 := Solenoid
temp3 := !LEDgun

OUTA[8]~                     'Set latch...
OUTA[9]~                     '... and clock to LOW to get started.
OUTA[8]~~                     'Set latches HIGH to start. No change for the lights (registers should still be same as last cycle), brings up first bit of Sense
OUTA[8]~                     'Reset latch for next time

repeat 32                       

  sense <<= 1          'Shift sense bits LEFT to allow next bit in for LSB    
  sense += INA[10]      'Set LSB of Sense to the bit on the Sense input (0 or 1) 

  sense1 <<= 1          'Shift sense bits LEFT to allow next bit in for LSB    
  sense1 += INA[13]      'Set LSB of Sense to the bit on the Sense input (0 or 1) 

  OUTA[12] := temp0              'Set next LSB bit for Light0 OUT
  OUTA[11] := temp1              'Set next LSB bit for Light1 OUT
  OUTA[14] := temp2              'Set next LSB bit for Solenoid OUT
  OUTA[15] := temp3              'Set next LSB for LED Gun out 
  
  OUTA[9]~~                  'CLK input and output shift registers
  OUTA[9]~                   'Sends OUT light data, brings IN sense data, which we now check

  temp0 >>= 1           'Shift light bits RIGHT to put next one in LSB
  temp1 >>= 1
  temp2 >>= 1
  temp3 >>= 1
  
OUTA[8]~~
OUTA[8]~                     'Set latches to output light data (also re-latches input data but who cares?)

sense := !sense                 'Invert SENSES so 1 equals contact, 0 equals none.
sense1 := !sense1    



PUB View (Value, Bit)

  if (Bit < 0) or (bit > 31)    'Return -1 if BIT < 0 or > 31
    return -1
  return Value >> Bit >< 1      'Return the bit

  

PUB Change (Value, Bit, State)
  
  if (Bit < 0) or (Bit > 31) or (State < -1) or (State > 1)  'Prevent errors
    return Value                                        'Return -1                                        
  IF (State <> -1)                                      'If state non-invert
    IF (View(Value, Bit) <> State)
      IF State                                          'Return with stated bit 1
        return Value + |< Bit
      else                                              'Return with stated bit 0
        return Value - |< Bit
  else
    if View(Value, Bit)                                 'Invert bit
      Return Value - |< Bit                             'Return with stated bit 0 if 1
    else
      return Value + |< Bit                             'Return with stated bit 1 if 0
  return Value                                          'Return value without editing if already state



PUB CheckWheel

OUTA[16]~~

OUTA[17] := 0                   'make I/O an output in the State you wish to measure... and then charge cap
DIRA[17] := 1                               
waitcnt(80_000 + cnt)                'pause for 1mS to charge cap
DIRA[17] := 0                       'make I/O an input
Wheel := cnt                        'grab clock tick counter value
repeat while INA[17] == 0
  'waitcnt(80_000 + cnt)                'pause for 1mS to charge cap   
  'WAITPEQ(1,|< 17,0)            'wait until pin goes into the opposite state you wish to measure; State: 1=discharge 0=charge
Wheel := cnt - Wheel               'see how many clock cycles passed until desired State changed
Wheel := Wheel - 1600              'offset adjustment (entry and exit clock cycles Note: this can vary slightly with code changes)
Wheel := Wheel >> 4                'scale result (divide by 16) <<-number of clock cycles per itteration loop
  
OUTA[16]~
  
'return RCTemp





'----------------------------------------------SOLENOID & MOTOR CONTROL-----------------------------------------------------------    

PUB CheckCaptures(drainwait) | check

PollIO
repeat check from 9 to 11
  if View(Sense,check+7)
    KickCapture(check)
    if drainwait
      repeat while View(Sense,13) == 0
        PollIO
      Pause(20)  
      KickCapture(6)


PUB KickCapture(sol)       'Give solenoid bit 9, 10 or 11

Solenoid := Change(Solenoid, sol, 1)              'Reset drop targets 
PollIO
Pause(20)
Solenoid := Change(Solenoid, sol, 0)              'Release DT solenoid
PollIO  


PUB MakeWaves

Waves += 1
if waves == 1
  Solenoid := Change(Solenoid, 31, 1)             'Start step  
if waves == 7
  Solenoid := Change(Solenoid, 31, 0)             'Stop step
if waves == 30
  waves := 0


PUB KillWaves

Solenoid := Change(Solenoid, 31, 0)                     'Kill the waves, if any
PollIO


Pub Resetdroptargets

KickCapture(7)
Targetcount := 0
droptargets := 0


PUB MotorCW(motor)

Solenoid := Change(Solenoid, (motor * 2) + 16, 1)
Solenoid := Change(Solenoid, (motor * 2) + 17, 0)
PollIO


PUB MotorCCW(motor)

Solenoid := Change(Solenoid, (motor * 2) + 16, 0)
Solenoid := Change(Solenoid, (motor * 2) + 17, 1)
PollIO


PUB MotorBrake(motor)

Solenoid := Change(Solenoid, (motor * 2) + 16, 1)
Solenoid := Change(Solenoid, (motor * 2) + 17, 1)
PollIO


PUB MotorStop(motor)

Solenoid := Change(Solenoid, (motor * 2) + 16, 0)
Solenoid := Change(Solenoid, (motor * 2) + 17, 0)
PollIO


PUB ResumeStates                                      'If sub was paused, this restarts it from the smoldering ruins of whatever happened

if SubState == 1                                      'Resume letting sub goto left edge
  MotorCCW(3)
if SubState == 25                                     'If sub was hit and being put back...             
  MotorCW(3)                                          'resume motor


PUB GateOpen

MotorCW(0)
Pause(5)
MotorStop(0)


PUB GateClose

MotorCCW(0)
Pause(5)
MotorStop(0)


PUB TrapOpen

MotorCW(1)                                           'Set sub trap door to OPEN
Pause(20)
Motorstop(1)


PUB TrapClose

MotorCCW(1)                                           'Set sub trap door to CLOSED
Pause(20)
Motorstop(1)

  

'----------------------------------------------DOT MATRIX DISPLAY CONTROL-----------------------------------------------------------

PUB StatusDisplay                                       'Show current status if nothing much is going on

StatusType += 1

if StatusType == 1
  ShowBalls(250_000)
if StatusType == 2
  ScoreLoop(16)
  StatusType := 0
    

PUB ShowBalls(speed)

    
if ball == 1
  fr.static(string("BALL;ONE"),speed)
if ball == 2
  fr.static(string("BALL;TWO"),speed)
if ball == 3
  fr.static(string("BALL;THREE"),speed)

      
PUB ShowPlayer

if CurrentPlayer == 1
  fr.static(string("PLAYER;ONE"),0)
if CurrentPlayer == 2
  fr.static(string("PLAYER;TWO"),0)
if CurrentPlayer == 3
  fr.static(string("PLAYER;THREE"),0)
if CurrentPlayer == 4
  fr.static(string("PLAYER;FOUR"),0)


PUB BlinkDrops(state)

repeat g from 16 to 19
  Blink0 := Change(Blink0, g, state)                        'Set drop targets to blink


PUB DisplayStop

COGSTOP(1)                                              'Kill the animation cog
Display := 0                                            'Set display type to 0 (none / score) 


 
PUB AnimatorLoop(frames,which,speedframes,loops,scoreshow,xPos,yPos,xEnd,yEnd,speedscroll,PriCheck)

g := DisplayCheck(PriCheck)
if g
  return 

COGINIT(1,AnimatorRun(frames,which,speedframes,loops,scoreshow,xPos,yPos,xEnd,yEnd,speedscroll),@CogStackD)


PUB AnimatorRun(frames,which,speedframes,loops,scoreshow,xPos,yPos,xEnd,yEnd,speedscroll) | sds

Display := 2                                            '2 means animation

e.Initialize(28)
e.ReadPage(28, $A0, (which*256)+32768, @Screen, 128)
'waitcnt(10_000_000 + cnt)
e.ReadPage(28, $A0, (which*256)+32_896, @Screen+128, 128)

repeat loops                                                  'Cycle through frames until judgement day or the cog is terminated, whichever comes first
  sds := 0                                              'Frame memory page counter. (I'm giving "i" the day off)
  repeat frames
    fr.frame(@Screen+(sds * 64), xPos, yPos)                      'Call FRAME method in Display, pointing at the desired page of screen memory
    sds := sds + 1                                      'Increment page counter / over-comment code
    waitcnt(speedframes + cnt)                               'Likewise, in case this wasn't completely obvious, wait desired amount of clock cycles between frames. (at 80MHz)
      if xPos > xEnd
        xPos -= speedscroll
      if xPos < xEnd
        xPos += speedscroll
      if yPos > yEnd
        yPos -= speedscroll
      if yPos < yEnd
        yPos += speedscroll    

display := 0

if drain == 0 and scoreshow
  ScoreLoop(scoreshow)


PUB SlingBonus                                          'Do crap based off mode when player gets 3 sling hits in a row.

if TheSun                                               'Near Dark mode (as long as the sun is blinking)
  SoundLoop(99,7,6,180)
  ScoreBonus(string("REDNECK;KILL"),65,(SlingShot * 250_000) * NeckBonus, 12, 5)

if mode == 0                                                    'If nothing's going on, do Navy Seals sniper stuff
  g := ||?cnt // 6
  g += 1
  SoundLoop(99,15,g,180)
  ScoreBonus(string("SNIPER;KILL"),65,SlingShot * 100_000,12,5)

SlingShot := 0                                          'Once we've used them to compute score, reset SlingShot.   


PUB ShowDemons(count)

display := 5                                            '5 means Demon Bonus
fr.static(string("DEMON;KILLS"),0)
Pause(40)
repeat 5
  fr.score(count,8)
  Pause(5)
  fr.static(string(";"),0)
  Pause(5)
  
display := 0
scoreloop(0)


PUB Scoreloop(startY)

if display == 0
  fr.score(score,startY)


PUB StaticLoop(str_addr,scroll,time,PriCheck)

g := DisplayCheck(PriCheck)
if g
  return

COGINIT(1,StaticRun(str_addr,scroll,time),@CogStackD)


PUB StaticRun(str_addr,scroll,time)

fr.static(str_addr,scroll)
Pause(Time)                                             'Keeps the text on the screen this minimum amount of time... (0 prints it but allows immediate, well, NEAR-immediate redrawal)
DisplayReady                                            'before allowing it to be overwritten 


PUB ScrollLoop(str_addr,speed,scoreshow,PriCheck)

g := DisplayCheck(PriCheck)
if g
  return

COGINIT(1,ScrollRun(str_addr,speed,scoreshow),@CogStackD) 


PUB ScrollRun(str_addr,speed,scoreshow)

Display := 3                                            '3 means scrolling
fr.scroll(str_addr,speed)
if scoreshow and drain == 0
  fr.score(score,8)
Display := 0                                            '0 means Display Free


PUB ScoreBonus(str_addr,waittime, bonus0, blink, speed)

Score += Bonus0                                         'Give the points right away

if display<>0
  return                                                'If display is busy don't do anything

COGINIT(1,ScoreBonusRun(str_addr,waittime, bonus0, blink, speed),@CogStackD)


PUB ScoreBonusRun(str_addr,waittime, bonus0, blink, speed)

Display := 4                                            '4 means Score Bonus
fr.static(str_addr,0)
Pause(waittime)                                         'Give the message onscreen some time...
fr.static(string("SCORE;BONUS"),0)
Pause(60)
repeat blink
  fr.score(bonus0,8)
  Pause(speed)
  fr.static(string(";"),0)
  Pause(speed)
if drain == 0
  fr.score(score,16)
Display := 0


PUB DisplayReady                                        'Wipes out values and allows display to be overwritten. Does NOT clear display

display := 0
DisplayPriority := 0


PUB DisplayCheck(PriCheck)                                        'Return 0 = go ahead, return 1 = something more important is on, abort

if display<>0
  if PriCheck < DisplayPriority                         'Is current text less important than whatever's happing? (Equal importance lets new text through)
    return 1
  else
    COGSTOP(1)                                            'Kill any display occuring
    fr.static(string(";"),0)                             'and clear the display
    DisplayPriority := PriCheck                             'Set latest priority as current
    return 0
else
  return 0






'----------------------------------------------SOUND & MUSIC CONTROL / PLAYERS----------------------------------------------------------- 


PUB Musicloop(group,clip)


repeat
  music.play(group,clip)                                'Unlike sound clips, music loops forever and must be manually stoped wth - get this - MUSICSTOP


PUB Musicstop

COGSTOP(5)                                              'Terminate music player  
COGSTOP(3)                                              'and the cog this code is in. Dead!

    
PUB StartRandomMusic | clip                  'Start random music. If Multiplier, play 2nd half of whatever is already playing

clip := (||?cnt // 5) + 1                                     'Limit 13 different 2-half random music combos 

COGINIT(3,musicloop(26,clip),@CogstackM)                '26 is group for "Random Music" sounds.


PUB MountSD | i
 
i:=sd1.mount(4)



PUB Singfish | temp, gg

Display := 9                                            '9 means Singing Fish, I guess
                                                        'Even though this doesn't use the display, it uses Cog 1, so we have to keep other things from using that til we're done
DisplayPriority := 11                                   'It goes to 11.

repeat gg from 0 to 1
  temp := FishHead[gg]
  repeat 32
    Solenoid := Change(Solenoid, 15, temp & 1)
    Waitcnt(11_500_000 + cnt)
    temp >>= 1 

Display := 0                                            'Ok, other stuff can happen now
DisplayPriority := 0


PUB ModeLaunchSound | bank, clipnum, clip

clipnum := ||?cnt // 10                                    'Randomly pick a Bill Paxton comment

if mode == 1                                           'If Aliens Mode
  bank := 1
  clip := AlienQuote[clipnum]

if mode == 7
  bank := 3
  clip := ScienceQuote[clipnum]

else                                                    'If no valid modes
  bank := GeneralQuote[clipnum * 2] 
  clip := GeneralQuote[(clipnum * 2)+1] 

SoundLoop(99,bank,clip,255)


PUB Soundstop

SoundGo := 0
repeat while soundwait == 1
guncount := 0


PUB SoundLoop(type,group,clip,priority)                 'Priority is from 0 (lowest) to 255 (highest)

if soundwait                                            'If a sound is playing, check priorities
  if priority < Interrupt                               'If current sound request is lower priority than what is already playing...
    return                                              '...RETURN, new sounds can't play until old one finishes
  else
    SoundStop                                           'Else, KILL CURRENT SOUND

BoredDisplay := 0
Interrupt := Priority                                   'Set Interrupt to the new priority
COGINIT(2,SoundPlay(type,group,clip),@CogstackS)               'and start new one


PUB SoundPlay(type,group,clip) | Samples, n, j

soundwait := 1
SoundGo := 1

soundload[0] := type
soundload[1] := group + 64
soundload[2] := clip + 64

'd.clr
'd.dbtext(string("File load attempt:"),1)
'd.dbtext(@soundload,1)
    
sd1.popen(@soundload, "r")

'd.dbtext(string("Success!"),1)

sd1.pread(@Header, 44)
'SampleRate:=Header[27]<<24+Header[26]<<16+Header[25]<<8+Header[24]
Samples:=Header[43]<<24+Header[42]<<16+Header[41]<<8+Header[40]
Samples:=Samples>>2

EOFFlag := 255
       
parameter1:=@buff1[0]
parameter2:=@buff2[0]
parameter3:=@EOFFlag
parameter4:=Samples
COGINIT(4,@ASMWAV,@parameter1)
  
'Keep filling buffers until end of file
'note:  using alternating buffers to keep data always at the ready...

j:=800   'number of bytes to read
  
repeat while (j==800)   'repeat until end of file 
    
  if (buff1[199]==0)
    j:=sd1.pread(@buff1, 800) 'read data words to input stereo buffer   

  if (buff2[199]==0)
    j:=sd1.pread(@buff2, 800) 'read data words to input stereo buffer

  if SoundGo == 0 or EOFFlag == 0
    Quit

sd1.pclose                      'We've got the data, or the sound is stopped, so close file no matter what

soundwait := 0                
SoundGo := 0
interrupt := 0


  
'----------------------------------------------ASSEMBLY CODE FOR SOUND CLIP PLAYER-----------------------------------------------------------  
DAT
  ORG 0
ASMWAV
'load input parameters from hub to cog given address in par
        movd    :par,#pData1             
        mov     x,par
        mov     y,#4  'input 4 parameters
:par    rdlong  0,x
        add     :par,dlsb
        add     x,#4
        djnz    y,#:par

setup
        'setup output pins
        MOV DMaskR,#1
        ROL DMaskR,OPinR
        OR DIRA, DMaskR
        MOV DMaskL,#1
        ROL DMaskL,OPinL
        OR DIRA, DMaskL
        'setup counters
        OR CountModeR,OPinR
        MOV CTRA,CountModeR
        OR CountModeL,OPinL
        MOV CTRB,CountModeL
        'Wait for SPIN to fill table
        MOV WaitCount, CNT
        ADD WaitCount,BigWait
        WAITCNT WaitCount,#0
        'setup loop table
        MOV LoopCount,SizeBuff  
        'ROR LoopCount,#1    'for stereo
        MOV pData,pData1
        MOV nTable,#1
        MOV EndFlag,pData3
        'setup loop counter
        MOV WaitCount, CNT
        ADD WaitCount,dRate


MainLoop
        SUB nSamples,#1
        CMP nSamples,TCsamp wc
        IF_C JMP #Done
        waitcnt WaitCount,dRate

        RDLONG Right,pData
        ADD Right,twos      'Going to cheat a bit with the LSBs here...  Probably shoud fix this!    
        MOV FRQA,Right
        ROL Right,#16       '16 LSBs are left channel...
        MOV FRQB,Right
        WRLONG Zero,pData
        ADD pData,#4

        'loop
        DJNZ LoopCount,#MainLoop
        
        MOV LoopCount,SizeBuff        
        'switch table       ?
        CMP nTable,#1 wz
        IF_Z JMP #SwitchToTable2
SwitchToTable1
        MOV nTable,#1
        MOV pData,pData1
        JMP #MainLoop
SwitchToTable2
        MOV nTable,#2
        MOV pData,pData2
        JMP #MainLoop
        
                
Done
         'now stop
        WRLONG Zero,EndFlag            'set Flag to zero
        COGID thisCog
        COGSTOP thisCog          

'Working variables
thisCog long 0
x       long 0
y       long 0
dlsb    long    1 << 9
BigWait long 100000
twos    long $8000_8000
        
'Loop parameters
nTable  long 0
WaitCount long 0
pData   long 0
LoopCount long 0
SizeBuff long 200
'Left    long 0
Right   long 0
Zero    long 0          
EndFlag long 0

'setup parameters
DMaskR  long 0 'right output mask
OPinR   long 23 'right channel output pin #                        '   <---------  Change Right pin# here !!!!!!!!!!!!!!    
DMaskL  long 0 'left output mask 
OPinL   long 22 'left channel output pin #                         '   <---------  Change Left pin# here !!!!!!!!!!!!!!    
CountModeR long %00011000_00000000_00000000_00000000
CountModeL long %00011000_00000000_00000000_00000000
dRate   long 1814  'clocks between samples 
TCsamp  long 2_200  'Ends file halfway through the standard EOF 1/10th of a second silence

'input parameters
pData1   long 0 'Address of first data table        
pData2   long 0 'Address of second data table
pData3   long 0
nSamples long 2000



'----------------------------------------------DATA USED BY MAIN GAME----------------------------------------------------------- 
DAT

         SEG7LED        BYTE %11111100          '0
                        BYTE %01100000          '1
                        BYTE %11011010          '2
                        BYTE %11110010          '3
                        BYTE %01100110          '4
                        BYTE %10110110          '5
                        BYTE %10111110          '6
                        BYTE %11100000          '7
                        BYTE %11111110          '8
                        BYTE %11110110          '9

         ApolloData     BYTE 3,20,0,8,128,8,2
                        BYTE 10,5,64,8,64,8,1
                        BYTE 10,7,64,8,64,8,1
                        BYTE 17,5,64,16,64,8,1
                        BYTE 10,8,64,8,64,8,1
                        BYTE 9,10,64,0,64,8,1

         TitanicIn      BYTE 8,4,10,12,2

         TitanicOut     BYTE 11,5,13,9,2

         GeneralQuote   BYTE 6,3, 4,1, 4,26, 4,5, 16,1, 3,13, 2,1, 8,1, 9,1, 26,1  

         AlienQuote     BYTE 1,5,6,12,14,15,16,17,21

         ScienceQuote   BYTE 6,9,10,11,12,14,16,20,9,6

         OutLaneQuote   BYTE 3,19, 1,1, 4,6, 4,2, 5,6, 13,10, 7,7, 3,15

         InLaneQuote    BYTE 3,18, 1,14, 4,8, 4,5, 5,1, 26,3, 7,3, 3,10   

         DrainQuote     BYTE 1,3, 1,20, 2,8, 3,4, 3,3, 3,21, 3,23, 11,2, 4,11, 4,20, 4,24, 5,7, 6,1, 7,5, 8,3, 9,5, 10,4, 10,1 ,14,5 ,16,4, 17,5
         
         TrueData       BYTE 3,4,4,21,1,3,2,19,2,22      'First 2 bytes are dummy bytes

         BoomBits       LONG %00000000000100000011100000100000, %01100000011000000000000000000000, %00000000000000000000000001011111

         DrainBits      LONG %00000000000000000000000000000110, %00000000000000000000000000010001, %01100000000000000000000000000000, %00000000011000000000000000000000, %00000000000000000000000000000000

         FishHead       LONG %11001101010101001100110011001100, %00011100010101001100110011001100



         