CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000       '80 MHz

  led = 25      'Start pin 0 of the LED display. Pin 0 =CLK, Pin +1 = Latch, Pin +2 = Data


VAR

  byte nstr[9]
  byte comx

Pub SetPins

DIRA[24..27]~~                                        'Set pins for LED display
OUTA[24]~~                                            'Enables display 


PUB Score(scorex,yPos) | div, z_pad, idx, col, padding, dots, x, lx, size

SetPins
   
  div := 100_000_000                                  ' initialize divisor
  z_pad~                                                ' clear zero-pad flag
  bytefill(@nstr, 0, 9)                                ' clear string to zeros
  idx~
  size := 0                                                  ' reset index
    
  repeat 9
    if (scorex => div)                                   ' printable character?
      nstr[idx++] := (scorex / div + "0")                '   yes, print ASCII digit
      scorex //= div                                     '   update value
      z_pad~~
      size := size + 1                                           '   set zflag
    elseif z_pad or (div == 1)                          ' printing or last column?
      nstr[idx++] := "0"
    div /= 10



repeat
  X := 0
  size := strsize(@nstr)
  col := size
  Padding := (64-(size*5))/2
  div := 0
  OUTA[led+2] := 0  

  repeat 256                                 'Buffer in left-hand spacing.
    dclock 

  repeat size
    LX := BYTE[@nstr + X]           'Get value of next STRING letter, asign ASCII value   
    LX -= 48                      'Lob off useless first 32, in our ASCII, 0 is first
    LX *= 5                       'Jump to correct letter in database
    X += 1                         'Increment to next letter for next time
    repeat 5                           'Each character has 5 columns, including final "space"
      DOTS := Charset.byte[LX]
      LX += 1
      div += 1              'Use this variable to count how many columns we use, for spacing later
      FillColumn(yPos, Dots)
     
    if col == 7 or col == 4
      makecomma(yPos)
      div += 3
 
    col -= 1      
           
  OUTA[led+2] := 0                'Clear data bit for spacing
  div := (64 - div) / 2
  
  repeat div
    repeat 8                 
      dclock

  dlatch                 'Enable latches once all characters are loaded

  if yPos == 8
    quit
  if yPos < 8
    yPOs += 1
  if yPos > 8
    yPos -= 1
  



PUB Makecomma(yPos) | dots, lx  

repeat lx from 0 to 2
  DOTS := Comma.byte[LX]
  FillColumn(yPos, Dots) 


PUB Static(str_addr,scrl) | padding, dots, x, lx, size     'Method to display single-line messages. They can either appear instantly, or scrl-on (second variable > 0 in clock cycles per column)
                                                        'Once loaded they stay onscreen (stored in shift registers) until main program calls this method again to change it.
SetPins 

X := 0
size := strsize(str_addr)
Padding := (64-(size*5))/2

repeat 8 * Padding
  OUTA[led+2] := 0              'Buffer in left-hand spacing.
  dclock 

repeat size
  LX := BYTE[str_addr + X]           'Get value of next STRING letter, asign ASCII value   
  LX -= 48                      'Lob off useless first 32, in our ASCII, 0 is first
  LX *= 5                       'Jump to correct letter in database
  X += 1                         'Increment to next letter for next time
  repeat 5                           'Each character has 5 columns, including final "space"
    DOTS := Charset.byte[LX]
    LX += 1
    FillColumn(8, Dots) 
    if scrl
        dlatch               'scrl In. When scrling, we reveal the latches every 8 cycles for column-by-column scrolling
        WAITCNT (scrl + CNT)      'scrl In              

repeat Padding
  OUTA[led+2] := 0              'Buffer in right-hand spacing.
  repeat 8
    dclock
  if scrl
    dlatch                      'scrl In
    WAITCNT (scrl + CNT)      'scrl In  

dlatch                 'Enable latches once all characters are loaded





PUB Scroll(str_addr,scrl) | dots, x, lx, size          'scrls a long line of text across the screen, then clears screen.

SetPins 

Static(string(";;;;"),0)

X := 0
size := strsize(str_addr)

repeat size
  LX := BYTE[str_addr + X]           'Get value of next STRING letter, asign ASCII value   
  LX -= 48                      'Lob off useless first 32, in our ASCII, 0 is first
  LX *= 5                       'Jump to correct letter in database
  X += 1                         'Increment to next letter for next time
  repeat 5                           'Each character has 5 columns, including final "space"
    DOTS := Charset.byte[LX]
    LX += 1
    FillColumn(8, Dots) 
    dlatch               'scrl In. This mode is always scrling, so the if-then is removed.
    WAITCNT (scrl + CNT)         'Add desired delay. Scroll ALWAYS has a scroll delay time set    

OUTA[led+2] := 0                 'Clear bits in prep for scroll-off 

repeat 64                       'Once message has finished, scroll the whole thing off-screen        
            
  repeat 8                      'Eight clocks per line...               
    dclock
  dlatch                        'Latch out every line, 64 times.                
  WAITCNT (scrl + CNT)          'Add desired delay




  

PUB Frame(str_addr, xPos, yPos) | x, dots, showX, rest, pre, post

SetPins 

if xPos < 64
  rest := 0
  showX := xPos
  X := 0  
  repeat (64 - xPos)
    repeat 8
       OUTA[led+2] := 0         'Clock out blanks
       dclock

if xPos > 63
  X := xPos - 64
  showX := 64 - x
  rest := 64 - showX

if showX
  repeat showX
    DOTS := BYTE[str_addr + X]        'Get value of next STRING letter, asign ASCII value   
    X += 1                        'Increment to next letter for next time
    FillColumn(yPos, Dots)

if rest
  repeat rest
    repeat 8
       OUTA[led+2] := 0         'Clock out blanks
       dclock  
 
dlatch                 'Enable latches once all characters are loaded


PUB FillColumn(yPos, Dots)

if yPos < 8
  DOTS >>= 8 - yPos
if yPos > 7
  DOTS <<= 8 - (16 - yPos)                                      
repeat 8
  OUTA[led+2] := DOTS         'LSB of LX output to shift register
  dclock                      ' SCK high (clock in)
  DOTS >>= 1           ' Shift bits of LX RIGHT ONE, thus putting the new "key" bit in the LSB spot, which is what gets shifted out. Viola.  



PUB dclock

  OUTA[led] := 1               ' SCK high (clock in)  
  OUTA[led] := 0               ' SCK low (ready for next)
  

PUB dlatch

  OUTA[led+1] := 1               'Reveal contents of shift registers to the latches
  OUTA[led+1] := 0               'Reset for next time

    
DAT


                                                
         Comma          BYTE %00001101          ',
                        BYTE %00001110
                        BYTE %00000000

         Charset        BYTE %01111110          '0      'An ASCII table, shifted -40, ranging from 0-50 (40-90 ASCII originally) 
                        BYTE %11000011
                        BYTE %11000011
                        BYTE %01111110
                        BYTE %00000000

                        BYTE %00100001          '1
                        BYTE %01111111
                        BYTE %11111111
                        BYTE %00000001
                        BYTE %00000000

                        BYTE %01100011          '2
                        BYTE %11001111
                        BYTE %11111011
                        BYTE %01100011          
                        BYTE %00000000

                        BYTE %11000011          '3 
                        BYTE %11011011
                        BYTE %11111111                        
                        BYTE %01101110          
                        BYTE %00000000

                        BYTE %11110000          '4 
                        BYTE %00011000
                        BYTE %00011000                        
                        BYTE %11111111
                        BYTE %00000000

                        BYTE %11111011          '5
                        BYTE %11011011
                        BYTE %11011011
                        BYTE %11011111
                        BYTE %00000000

                        BYTE %01111110          '6 
                        BYTE %11011011
                        BYTE %11011011                        
                        BYTE %11001110           
                        BYTE %00000000

                        BYTE %11000000          '7
                        BYTE %11000000
                        BYTE %11111111
                        BYTE %11111111
                        BYTE %00000000

                        BYTE %01101110          '8
                        BYTE %11011011
                        BYTE %11011011
                        BYTE %01101110
                        BYTE %00000000

                        BYTE %01110000          '9
                        BYTE %11011000
                        BYTE %11011000                        
                        BYTE %11111111          
                        BYTE %00000000

                        BYTE %00000000          ':
                        BYTE %01100110
                        BYTE %01100110
                        BYTE %00000000
                        BYTE %00000000

                        BYTE %00000000          '; (Use as SPACE)
                        BYTE %00000000
                        BYTE %00000000
                        BYTE %00000000
                        BYTE %00000000

                        BYTE %00000000          '< (Use as EXCLAMATION)
                        BYTE %11110011
                        BYTE %11110011
                        BYTE %00000000
                        BYTE %00000000

                        BYTE %00100100          '=
                        BYTE %00100100
                        BYTE %00100100
                        BYTE %00100100
                        BYTE %00000000
                        
                        BYTE %10000001          '>
                        BYTE %01000010
                        BYTE %00100100
                        BYTE %00011000
                        BYTE %00000000
                       
                        BYTE %01100000          '?
                        BYTE %11001011
                        BYTE %11011011
                        BYTE %01110000
                        BYTE %00000000

                        BYTE %00111100          '@
                        BYTE %01111110
                        BYTE %01111110
                        BYTE %00111100
                        BYTE %00000000

                        BYTE %01111111          'A
                        BYTE %11011000
                        BYTE %11011000
                        BYTE %01111111
                        BYTE %00000000

                        BYTE %11111111          'B
                        BYTE %10011001
                        BYTE %10011001
                        BYTE %01101110
                        BYTE %00000000

                        BYTE %01111110          'C
                        BYTE %11000011
                        BYTE %11000011
                        BYTE %01100110
                        BYTE %00000000

                        BYTE %11111111          'D
                        BYTE %11000011
                        BYTE %11100111
                        BYTE %01111110
                        BYTE %00000000

                        BYTE %11111111          'E
                        BYTE %11011011
                        BYTE %11011011
                        BYTE %11011011
                        BYTE %00000000

                        BYTE %11111111          'F
                        BYTE %11011000
                        BYTE %11011000
                        BYTE %11011000
                        BYTE %00000000

                        BYTE %01111110          'G
                        BYTE %11000011
                        BYTE %11001011
                        BYTE %11001110
                        BYTE %00000000                        

                        BYTE %11111111          'H
                        BYTE %00011000
                        BYTE %00011000
                        BYTE %11111111
                        BYTE %00000000

                        BYTE %10000001          'I  
                        BYTE %11111111
                        BYTE %11111111
                        BYTE %10000001
                        BYTE %00000000

                        BYTE %10000110          'J
                        BYTE %10000011
                        BYTE %11111110
                        BYTE %10000000
                        BYTE %00000000

                        BYTE %11111111          'K
                        BYTE %00111100
                        BYTE %01100110
                        BYTE %11000011
                        BYTE %00000000

                        BYTE %11111111          'L
                        BYTE %00000011
                        BYTE %00000011
                        BYTE %00000011
                        BYTE %00000000

                        BYTE %11111111          'M
                        BYTE %01111000
                        BYTE %01110000
                        BYTE %11111111
                        BYTE %00000000

                        BYTE %11111111          'N
                        BYTE %01111000
                        BYTE %00011110
                        BYTE %11111111
                        BYTE %00000000

                        BYTE %01111110          'O
                        BYTE %11000011
                        BYTE %11000011
                        BYTE %01111110
                        BYTE %00000000

                        BYTE %11111111          'P
                        BYTE %11011000
                        BYTE %11011000
                        BYTE %01110000
                        BYTE %00000000

                        BYTE %01111110          'Q
                        BYTE %11000011
                        BYTE %11000010
                        BYTE %01111101
                        BYTE %00000000

                        BYTE %11111111          'R
                        BYTE %11011100
                        BYTE %11011110
                        BYTE %01110011
                        BYTE %00000000

                        BYTE %01110011          'S
                        BYTE %11011011
                        BYTE %11011011
                        BYTE %11001110
                        BYTE %00000000
                        
                        BYTE %11000000          'T
                        BYTE %11111111
                        BYTE %11111111
                        BYTE %11000000
                        BYTE %00000000

                        BYTE %11111110          'U
                        BYTE %00000011
                        BYTE %00000011
                        BYTE %11111110
                        BYTE %00000000
                        
                        BYTE %11111000          'V
                        BYTE %00001110
                        BYTE %00000011
                        BYTE %11111100
                        BYTE %00000000
                        
                        BYTE %11111110          'W (This letter looks like shit, I know)
                        BYTE %00001111
                        BYTE %00001111
                        BYTE %11111110
                        BYTE %00000000
                        
                        BYTE %11100111          'X
                        BYTE %00111100
                        BYTE %00111100
                        BYTE %11100111
                        BYTE %00000000
                        
                        BYTE %11110000          'Y
                        BYTE %00011111
                        BYTE %00011111
                        BYTE %11110000
                        BYTE %00000000

                        BYTE %11000111          'Z
                        BYTE %11011111
                        BYTE %11110011
                        BYTE %11000011
                        BYTE %00000000



                                               