                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
#include <EEPROM.h>
#include "config.h"

void setup() {

  Serial.begin(19200);  

  Serial.println(" ");
  Serial.println("------------------------------------------------");  
  Serial.println("     Xbox 360 Controller Monitor Version 4a     ");
  Serial.println("www.benheck.com/360monitor for usage information");
  Serial.println("------------------------------------------------");
  Serial.println(" ");

  analogReference(EXTERNAL); //DO NOT CHANGE!
 
  TRISE = (B11111111 << 8 ) + B11111111; //Set port E as input
  TRISD = (B00001111 << 8 ) + B00000000; //Set top half of port D as input 

  pinMode(3, OUTPUT);  //Serial shift register out
  pinMode(5, OUTPUT);
  pinMode(6, OUTPUT);

  pinMode(user0, INPUT);
  pinMode(config, INPUT);
  
  pinMode(led0, OUTPUT);
  pinMode(led1, OUTPUT); 

  digitalWrite(led0, 0);
  digitalWrite(led1, 0); 
  
  output[0] = 0;
  output[1] = 0;
  output[2] = 0;
  output[3] = 0;
  output[4] = 0;
  output[5] = 0;
  output[6] = 0;

  GetDefaults();

}


void loop () {

  if (digitalRead(config) == 0) { //Config button pressed?
    Configuration();			  //Goto config screen
  }

  Load(); //Get data frame from controller 

  BuildTriggers(); //Arrange lights for analog triggers
  
  BuildLeft(); //Arrange lights for left analog stick
  
  BuildRight(); //Arrange lights for right analog stick
  
  Display(); //Send light data out to shift registers

}  

void BuildTriggers() {

  output[6] = 0;
  
  delta = (LT - LTc) - (LTd + TriggerBottom); //Compute distance
  
  temp = B00010000; //Starting bit
 
	while(delta > 0) {	//This is like ML. 
	  
	  output[6] |= temp; //Keep adding bits
	  temp <<= 1;
	  
	  delta -= LTd; // as many times as delta divides by 66 by way of subtration.
	}

  delta = (RT - RTc) - (RTd + TriggerBottom); //Compute distance
  
  temp = B00000001; //Starting bit
  
	while(delta > 0) {	//This is like ML. 
	  
	  output[6] |= temp; //Keep adding bits
	  temp <<= 1;
	  
	  delta -= RTd; // as many times as delta divides by 66 by way of subtration.
	}

}

void BuildLeft() {

  output[0] = 0;
  output[1] = 0;
 
	if (LY > LYc) { // Going up?

	    delta = (LY - LYc) - LYUsense; //Compute distance
  
		temp = B00000001; //Starting bit
 
		while(delta > 0) {	//This is like ML. 
		  
		  output[1] |= temp; //Keep adding bits
		  temp <<= 1;
		  
		  delta -= LYu; // as many times as delta divides by 66 by way of subtration.
		}

	}
	
	if (LY < LYc) { // Going down?

	    delta = (LYc - LY) - LYDsense; //Compute distance
  
		temp = B00000001; //Starting bit
 
		while(delta > 0) {	//This is like ML. 
		  
		  output[0] |= temp; //Keep adding bits
		  temp <<= 1;
		  
		  delta -= LYd; // as many times as delta divides by 66 by way of subtration.
		}	
	
	
	}

	if (LX > LXc) { // Going left?

	    delta = (LX - LXc) - LXLsense; //Compute distance
  
		temp = B00010000; //Starting bit
 
		while(delta > 0) {	//This is like ML. 
		  
		  output[0] |= temp; //Keep adding bits
		  temp <<= 1;
		  
		  delta -= LXl; // as many times as delta divides by 66 by way of subtration.
		}

	}
	
	if (LX < LXc) { // Going right?

	    delta = (LXc - LX) - LXRsense; //Compute distance
  
		temp = B00010000; //Starting bit
 
		while(delta > 0) {	//This is like ML. 
		  
		  output[1] |= temp; //Keep adding bits
		  temp <<= 1;
		  
		  delta -= LXr; // as many times as delta divides by 66 by way of subtration.
		}	
	
	
	}	
	
}

void BuildRight() {

  output[3] = 0;
  output[4] = 0;
 
	if (RY > RYc) { // Going up?

	    delta = (RY - RYc) - RYUsense; //Compute distance
  
		temp = B00000001; //Starting bit
 
		while(delta > 0) {	//This is like ML. 
		  
		  output[4] |= temp; //Keep adding bits
		  temp <<= 1;
		  
		  delta -= RYu; // as many times as delta divides by 66 by way of subtration.
		}

	}
	
	if (RY < RYc) { // Going down?

	    delta = (RYc - RY) - RYDsense; //Compute distance
  
		temp = B00000001; //Starting bit
 
		while(delta > 0) {	//This is like ML. 
		  
		  output[3] |= temp; //Keep adding bits
		  temp <<= 1;
		  
		  delta -= RYd; // as many times as delta divides by 66 by way of subtration.
		}	
	
	
	}

	if (RX > RXc) { // Going left?

	    delta = (RX - RXc) - RXLsense; //Compute distance
  
		temp = B00010000; //Starting bit
 
		while(delta > 0) {	//This is like ML. 
		  
		  output[3] |= temp; //Keep adding bits
		  temp <<= 1;
		  
		  delta -= RXl; // as many times as delta divides by 66 by way of subtration.
		}

	}
	
	if (RX < RXc) { // Going right?

	    delta = (RXc - RX) - RXRsense; //Compute distance
  
		temp = B00010000; //Starting bit
 
		while(delta > 0) {	//This is like ML. 
		  
		  output[4] |= temp; //Keep adding bits
		  temp <<= 1;
		  
		  delta -= RXr; // as many times as delta divides by 66 by way of subtration.
		}	
	
	
	}	
	
}

void Load() {    //Gets the current controller data into memory

  RT = analogRead(6);

  RX = analogRead(7);

  RY = analogRead(8);

  LX = analogRead(9);

  LY = analogRead(10);

  LT = analogRead(11);

  output[5] = ~PORTE; //Load inverse of PORTE LSB's into Byte 5.

  temp = PORTD & Dmask; //Load inverse of PORTD 8-11 into Output 2
  output[2] = ~temp >> 8;

}

void Display() {
  
  shiftOut(3, 6, LSBFIRST, output[0]);
  shiftOut(3, 6, LSBFIRST, output[1]);
  shiftOut(3, 6, LSBFIRST, output[2]);
  shiftOut(3, 6, LSBFIRST, output[3]);
  
  shiftOut(3, 6, LSBFIRST, output[4]);
  shiftOut(3, 6, LSBFIRST, output[5]);
  shiftOut(3, 6, LSBFIRST, output[6]);
  
  digitalWrite(5, 1);
  digitalWrite(5, 0); //Strobe LATCH to load the data

}  

void WaitForA() {  //Waits for the user to press the "A" button.

  Load(); //Get current values

  while (bitRead(output[5], 0) == 1) {  //Wait for button to be released
  Load(); //Get current values
  Display();
  }
  
  delay(50);  //Debounce

  while (bitRead(output[5], 0) == 0) {  //Wait for button to be pressed...
  Load(); //Get current values
  Display();
  }

//Continue program execution!

}
 
void GetDefaults() {

  //Read default centers and range dividers

  LTc = EEPROM.read(0);
  RTc = EEPROM.read(1);
  LTd = EEPROM.read(2);
  RTd = EEPROM.read(3);

  LYc = EEPROM.read(7);
  LYu = EEPROM.read(8);
  LYd = EEPROM.read(9);
  
  LXc = EEPROM.read(4);
  LXl = EEPROM.read(5);
  LXr = EEPROM.read(6);
 
  RYc = EEPROM.read(13);
  RYu = EEPROM.read(14);
  RYd = EEPROM.read(15);
 
  RXc = EEPROM.read(10);
  RXl = EEPROM.read(11);
  RXr = EEPROM.read(12); 

  //Serial.println(LTc, DEC);

  if (LTc < 0 or LTc > 200) { //No data in EEPROM?
	  Serial.println("No configuration data present.");
	  Serial.println("Plug in controller and press CONFIG on back of monitor to set baseline values.");

	  digitalWrite(led0, 1);      //Turn on red light and force user to do config menu
  }

  
}  

void Configuration() {

  digitalWrite(led1, 1);      //Turn on red light and force user to do config menu
  
  Serial.println("Controller Monitor Configuration");
  Serial.println("www.benheck.com/360monitor for usage information");
  Serial.println("---------------------------------------------------");
  Serial.println(" ");
  Serial.println("Leave all analog controls in default positions and press A...");

  WaitForA();

  //Store center values
  LTc = LT;
  RTc = RT;
  RXc = RX;
  RYc = RY;
  LXc = LX;
  LYc = LY;
  
  EEPROM.write(0, LTc);  
  EEPROM.write(1, RTc);   

  EEPROM.write(7, LYc);
  EEPROM.write(4, LXc);
  
  EEPROM.write(13, RYc);
  EEPROM.write(10, RXc);
  

  Serial.println("Stored! ");
  Serial.println(" ");
  Serial.println("Pull LEFT TRIGGER fully and press A...");

  WaitForA();

  LTd = (LT - LTc) / 5;
  EEPROM.write(2, LTd); 

  Serial.println("LT+ max: ");
  Serial.println(LT);
  Serial.println("LT min: ");
  Serial.println(LTc);
  Serial.println("LT range: ");
  Serial.println(LT-LTc);   
   
  Serial.println(" ");
  Serial.println("Release left trigger, pull RIGHT TRIGGER fully and press A...");

  WaitForA();
 
  RTd = (RT - RTc) / 5;
  EEPROM.write(3, RTd);

  Serial.println("RT+ max: ");
  Serial.println(RT);
  Serial.println("RT min: ");
  Serial.println(RTc);
  Serial.println("RT range: ");
  Serial.println(RT-RTc);   

  Serial.println(" ");
  Serial.println("Release right trigger, push LEFT ANALOG fully UP and press A...");

  WaitForA();

  LYu = (LY - LYc) / 5;
  EEPROM.write(8, LYu);
  
  Serial.println("LEFT Y+ max: ");
  Serial.println(LY);
  Serial.println("LEFT Y+ min: ");
  Serial.println(LYc);
  Serial.println("LEFT Y+ range: ");
  Serial.println(LY-LYc);    

  Serial.println("Stored! ");
  Serial.println(" ");
  Serial.println("Push LEFT ANALOG fully DOWN and press A...");

  WaitForA();
  
  LYd = (LYc - LY) / 5;
  EEPROM.write(9, LYd);

  
  Serial.println("LEFT Y- min: ");
  Serial.println(LY);
  Serial.println("LEFT Y- max: ");
  Serial.println(LYc);
  Serial.println("LEFT Y- range: ");
  Serial.println(LYc - LY);   

  Serial.println("Stored! ");
  Serial.println(" ");
  Serial.println("Push LEFT ANALOG fully LEFT and press A...");

  WaitForA();

  LXl = (LX - LXc) / 5;
  EEPROM.write(5, LXl);   
  
  Serial.println("LEFT X+ max: ");
  Serial.println(LX);
  Serial.println("LEFT X+ min: ");
  Serial.println(LXc);
  Serial.println("LEFT X+ range: ");
  Serial.println(LX-LXc); 

  Serial.println("Stored! ");
  Serial.println(" ");
  Serial.println("Push LEFT ANALOG fully RIGHT and press A...");

  WaitForA();

  LXr = (LXc - LX) / 5;
  EEPROM.write(6, LXr);    
  
  Serial.println("LEFT X- min: ");
  Serial.println(LXc);
  Serial.println("LEFT X- max: ");
  Serial.println(LX);
  Serial.println("LEFT X- range: ");
  Serial.println(LXc-LX); 

  Serial.println("Stored! ");
  Serial.println(" ");
  Serial.println("Push RIGHT ANALOG fully UP and press A...");

  WaitForA();

  RYu = (RY - RYc) / 4;
  EEPROM.write(14, RYu);  
  
  
  Serial.println("RIGHT Y+ max: ");
  Serial.println(RY);
  Serial.println("RIGHT Y+ min: ");
  Serial.println(RYc);
  Serial.println("RIGHT Y+ range: ");
  Serial.println(RY-RYc);    

  Serial.println("Stored! ");
  Serial.println(" ");
  Serial.println("Push RIGHT ANALOG fully DOWN and press A...");

  WaitForA();

  RYd = (RYc - RY) / 4;
  EEPROM.write(15, RYd);  
  
  
  Serial.println("RIGHT Y- min: ");
  Serial.println(RY);
  Serial.println("RIGHT Y- max: ");
  Serial.println(RYc);
  Serial.println("RIGHT Y- range: ");
  Serial.println(RYc - RY);   


  Serial.println("Stored! ");
  Serial.println(" ");
  Serial.println("Push RIGHT ANALOG fully LEFT and press A...");

  WaitForA();

  RXl = (RX - RXc) / 4;
  EEPROM.write(11, RXl);    
  
  Serial.println("RIGHT X+ max: ");
  Serial.println(RX);
  Serial.println("RIGHT X+ min: ");
  Serial.println(RXc);
  Serial.println("RIGHT X+ range: ");
  Serial.println(RX-RXc); 

  Serial.println("Stored! ");
  Serial.println(" ");
  Serial.println("Push RIGHT ANALOG fully RIGHT and press A...");

  WaitForA();
  
  RXr = (RXc - RX) / 4;
  EEPROM.write(12, RXr);    
  
  Serial.println("RIGHT X- min: ");
  Serial.println(RXc);
  Serial.println("RIGHT X- max: ");
  Serial.println(RX);
  Serial.println("RIGHT X- range: ");
  Serial.println(RXc-RX); 

  Serial.println("Stored! ");
  Serial.println(" ");  
  Serial.println("---------------------------------------------------");
  Serial.println(" ");
  Serial.println("Configuration complete! Press A to continue...");   

  WaitForA();

  digitalWrite(led0, 0);
  digitalWrite(led1, 0);      //Turn on red light and force user to do config menu
  
  GetDefaults(); //This reloads data so we don't need to reboot.

  Serial.println("Resuming normal function.");
  Serial.println(" ");  
  
} 

void Print() {
  
  Serial.print(LX);
  Serial.print(" ");
  Serial.print(LY);
  Serial.print(" ");  
  Serial.print(RX);
  Serial.print(" ");
  Serial.print(RY);
  Serial.print("    "); 
  Serial.print(LT);
  Serial.print(" ");
  Serial.print(RT);
  Serial.println(" ");   
 
}

