//XBOX ONE CONTROLLER MONITOR
//www.benheck.com

#include <p32xxxx.h> 
#include <plib.h>

unsigned long flight = 0;
unsigned long averageUS = 0;
unsigned long sampleCount = 0;

//Define the pull state of the analog triggers. Can vary by controller

#define leftBare  325      //325	- Defaults
#define leftMid   242      //242	- Defaults
#define leftFull  160      //160	- Defaults

#define rightBare  325     //Increase these numbers
#define rightMid   242     //if lights not fully on.
#define rightFull  160     //For instance try 170 instead of 160 

#define leftH    A7
#define leftV    A8
#define leftT    A3
#define rightH   A4
#define rightV   A5
#define rightT   A6
#define aRef     A2

#define LAT      24
#define DAT      25
#define CLK      26

#define faceButtons	3
#define lightSensor	18

unsigned char flightType = 0;		//0 = None 1 = Face Buttons
									//21-22-23 Left Trigger 1 2 3 31-32-33 Right trigger 1 2 3

unsigned long lightData = 0;      //Used to build the serial output
unsigned long average = 0;

int leftTrigger = 0;
int rightTrigger = 0;
int leftAnalogH = 0;
int leftAnalogV = 0;
int rightAnalogH = 0;
int rightAnalogV = 0;

int leftHcenter = 0;
int leftVcenter = 0;
int rightHcenter = 0;
int rightVcenter = 0;

int rampCount = 0 ;
unsigned long triggerCounter = 0;


void setup() {
 
	analogReference(INTERNAL);
	Serial.begin(9600);

	pinMode(LAT, OUTPUT);  //Latch
	pinMode(DAT, OUTPUT);  //Data
	pinMode(CLK, OUTPUT);  //Clock
	
	pinMode(faceButtons, INPUT);
	pinMode(lightSensor, INPUT);
	
	commAll(1);
	delay(1000);
	showCommands();
	averageSticks();
	commAll(0);
	
}

void loop() {

	if (Serial.available() > 1) {	//A command?
		checkCommand();
	}

	if (digitalRead(faceButtons) == 1 and flightType == 1) {
		getTime();
	}
	
	lightData = 0;			//Clear outputs	
	checkTriggers();		//Check triggers
	checkAnalogs();			//Check analog sticks
	sendLights();			//Output to display
	
}

void checkTriggers() {
 
	if (analogRead(aRef) > 900) {
	
		if (triggerCounter == 0) {
			triggerCounter = micros();       
		} 
		
		if (micros() > (triggerCounter + 300)) {
    
			leftTrigger = analogRead(leftT);
			rightTrigger = analogRead(rightT);

			if (leftTrigger < leftBare) {	//Barely touched?
				lightData |= 1 << 0;
				if (flightType == 21) {
					getTime();
				}
			}
			if (leftTrigger < leftMid) {	//Middle?
				lightData |= 1 << 1;
				if (flightType == 22) {
					getTime();
				}				
			}	  
			if (leftTrigger < leftFull) {	//Fully pulled?
				lightData |= 1 << 2;
				if (flightType == 23) {
					getTime();
				}				
			}

			if (rightTrigger < rightBare) {	//Barely touched?
				lightData |= 1 << 27;
				if (flightType == 31) {
					getTime();
				}					
			}
			if (rightTrigger < rightMid) {	//Middle?
				lightData |= 1 << 28;
				if (flightType == 32) {
					getTime();
				}	
			}	  
			if (rightTrigger < rightFull) {	//Fully pulled?
				lightData |= 1 << 29;
				if (flightType == 33) {
					getTime();
				}					
			}     
		}
  }
  else {
    triggerCounter = 0;  
  }
   
}

void checkAnalogs() {

	leftAnalogH = analogRead(leftH);
	leftAnalogV = analogRead(leftV);
	rightAnalogH = analogRead(rightH);
	rightAnalogV = analogRead(rightV);

	//LEFT ANALOG STICK
	
	if (leftAnalogH < (leftHcenter - 70)) {	//Left?
		lightData |= 1 << 3;
		if (leftAnalogH < (leftHcenter - 105)) {
			lightData |= 1 << 4;	
		}
		if (leftAnalogH < (leftHcenter - 140)) {
			lightData |= 1 << 5;	
		}		
	}

	if (leftAnalogH > (leftHcenter + 70)) {	//Right?
		lightData |= 1 << 12;
		if (leftAnalogH > (leftHcenter + 105)) {
			lightData |= 1 << 13;	
		}
		if (leftAnalogH > (leftHcenter + 140)) {
			lightData |= 1 << 14;	
		}		
	}

	if (leftAnalogV < (leftVcenter - 70)) {	//Up?
		lightData |= 1 << 6;
		if (leftAnalogV < (leftVcenter - 105)) {
			lightData |= 1 << 7;	
		}
		if (leftAnalogV < (leftVcenter - 140)) {
			lightData |= 1 << 8;	
		}		
	}

	if (leftAnalogV > (leftVcenter + 70)) {	//Down?
		lightData |= 1 << 9;
		if (leftAnalogV > (leftVcenter + 105)) {
			lightData |= 1 << 10;	
		}
		if (leftAnalogV > (leftVcenter + 140)) {
			lightData |= 1 << 11;	
		}		
	}

	//RIGHT ANALOG STICK
	
	if (rightAnalogH < (rightHcenter - 70)) {	//Left?
		lightData |= 1 << 15;
		if (rightAnalogH < (rightHcenter - 105)) {
			lightData |= 1 << 16;	
		}
		if (rightAnalogH < (rightHcenter - 140)) {
			lightData |= 1 << 17;	
		}		
	}

	if (rightAnalogH > (rightHcenter + 70)) {	//Right?
		lightData |= 1 << 24;
		if (rightAnalogH > (rightHcenter + 105)) {
			lightData |= 1 << 25;	
		}
		if (rightAnalogH > (rightHcenter + 140)) {
			lightData |= 1 << 26;	
		}		
	}

	if (rightAnalogV < (rightVcenter - 70)) {	//Up?
		lightData |= 1 << 18;
		if (rightAnalogV < (rightVcenter - 105)) {
			lightData |= 1 << 19;	
		}
		if (rightAnalogV < (rightVcenter - 140)) {
			lightData |= 1 << 20;	
		}		
	}

	if (rightAnalogV > (rightVcenter + 70)) {	//Down?
		lightData |= 1 << 21;
		if (rightAnalogV > (rightVcenter + 105)) {
			lightData |= 1 << 22;	
		}
		if (rightAnalogV > (rightVcenter + 140)) {
			lightData |= 1 << 23;	
		}		
	}
	
	//Serial.print(leftAnalogH);
	//Serial.print("\t");
	//Serial.println(leftAnalogV);


}

void checkCommand() {

	char op0 = Serial.read();
	char op1 = Serial.read();

	if (op0 > 96) {						//Convert to upper-case
		op0 -= 32;
	}
	if (op1 > 96) {
		op1 -= 32;
	}	
	
	char x = Serial.read();				//Get the carriage return and New Line characters out of the buffer
	x = Serial.read();

	if (op0 == 'L') {					//Show left trigger?
		if (op1 == '1') {
			flightType = 21;
			Serial.println("LEFT TRIGGER time-of-flight at Start");
		}
		if (op1 == '2') {
			flightType = 22;
			Serial.println("LEFT TRIGGER time-of-flight at Middle");
		}
		if (op1 == '3') {
			flightType = 23;
			Serial.println("LEFT TRIGGER time-of-flight at Full Pull");
		}
	}
	if (op0 == 'R') {					//Show right trigger?
		if (op1 == '1') {
			flightType = 31;
			Serial.println("RIGHT TRIGGER time-of-flight at Start");
		}
		if (op1 == '2') {
			flightType = 32;
			Serial.println("RIGHT TRIGGER time-of-flight at Middle");
		}
		if (op1 == '3') {
			flightType = 33;
			Serial.println("RIGHT TRIGGER time-of-flight at Full Pull");
		}
	}
	if (op0 == 'F' and op1 == 'B') {	//Show face buttons?
		flightType = 1;
		Serial.println("Showing FACE BUTTONS time-of-flight");
	}
	if (op0 == 'X' and op1 == 'X') {	//Show left trigger?
		flightType = 0;
		Serial.println("Time-Of-Flight DISABLED");
	}
	if (op0 == 'H' and op1 == 'P') {	//Show left trigger?
		showCommands();
	}
	if (op0 == 'A' and op1 == 'V') {	//Average sticks?
		averageSticks();
	}	
	if (op0 == 'R' and op1 == 'S') {	//Reset timer average?
		averageUS = 0;
		sampleCount = 0;
		Serial.println("Sample Average Reset");
	}
	if (op0 == 'T' and op1 == 'T') {	//Test analog lights?
		Serial.print("Shift register TEST...");
		commAll(1);
		delay(2000);
		commAll(0);
		Serial.println(" done!");
	}	
}

void sendLights() {
  
  commLong(lightData); 
  digitalWrite(LAT, 1);
  digitalWrite(LAT, 0); //Strobe LATCH to load the data
  
}

void commLong(unsigned long longData) {
  
  for(int g; g < 32; g++) {
    digitalWrite(DAT, longData & B00000001);    
    digitalWrite(CLK, 1);
    digitalWrite(CLK, 0);
    longData >>= 1;
  }

}

void commAll(unsigned char whatState) {
  
  for(int g; g < 32; g++) {
    digitalWrite(DAT, whatState);    
    digitalWrite(CLK, 1);
    digitalWrite(CLK, 0);
  }
  
  digitalWrite(LAT, 1);
  digitalWrite(LAT, 0); //Strobe LATCH to load the data  

}
 
   
void getTime() {
  
  
    flight = ReadCoreTimer();  //Get current time
    
    while(PORTA & B00010000) {    //Wait for light sensor to go low

    }

    flight = (ReadCoreTimer() - flight);  //Find difference

    Serial.print((flight / 25) / 1000);            //40MHz clock, 2 cycles per count
    Serial.print(" ms\t");	
	
    Serial.print(flight / 25);            //40MHz clock, 2 cycles per count
    Serial.print(" us\t");
    
    averageUS += (flight / 25);
    sampleCount += 1;
    
    Serial.print("average us:");    
    Serial.println(averageUS / sampleCount);
    
    delay(1000);    

    Serial.println("Ready for Next Sample");
    Serial.println(" "); 
  
}

void showCommands() {

	Serial.println(" ");
	Serial.println("--------------------------------------------------");  
	Serial.println("       Xbox One Controller Monitor Version 1      ");
	Serial.println("www.benheck.com/xbox1monitor for usage information");
	Serial.println("--------------------------------------------------");
	Serial.println(" ");

	Serial.println(" ");	
	Serial.println("TIME OF FLIGHT SERIAL COMMANDS:");
	Serial.println(" ");	
	Serial.println("L1 L2 L3 - Display time for Left Trigger, at Start, Middle, or Full Pull");	
	Serial.println("R1 R2 R3 - Display time for Right Trigger, at Start, Middle, or Full Pull");
	Serial.println("FB - Display time for any Face Button XYAB");
	Serial.println("XX - Disable Timers");
	Serial.println("AV - Average the center position of Analog Sticks");
	Serial.println("RS - Reset sample time average value");
	Serial.println("HP - Help, show commands");
	Serial.println(" ");

}

void averageSticks() {

	lightData = 4294967295;

	sendLights();
	
	Serial.print("Averaging Analog Stick Centers... ");			//Compute analog stick center averages

	Serial.print("LEFT ");			//Compute analog stick center averages
		
	average = 0;
	for (int x = 0 ; x < 1000 ; x ++) {	
		average += analogRead(leftH);	
		delayMicroseconds(100);
	}
	leftHcenter = (average / 1000);

	average = 0;
	for (int x = 0 ; x < 1000 ; x ++) {	
		average += analogRead(leftV);
		delayMicroseconds(100);		
	}
	leftVcenter = (average / 1000);	

	Serial.print("RIGHT ");			//Compute analog stick center averages
		
	average = 0;
	for (int x = 0 ; x < 1000 ; x ++) {	
		average += analogRead(rightH);
		delayMicroseconds(100);		
	}
	rightHcenter = (average / 1000);
	
	average = 0;
	for (int x = 0 ; x < 1000 ; x ++) {	
		average += analogRead(rightV);
		delayMicroseconds(100);		
	}
	rightVcenter = (average / 1000);	
	Serial.println("done. "); 


}

