//Expedition Awareness Panning Camera System
//2011 Benjamin J Heckendorn
//Uses Arduino Nano PCB


const int dir0 = 2;
const int step0 = 3;
const int dir1 = 4;
const int step1 = 5;
const int Limit0 = 6;
const int Limit1 = 8;
const int Reset = 7; //User "home cameras" button

const int DelayT = 2000;

int button = 0; //Used for sensing switches
int Pot0; // Value of pot levers
int Pot1;
int Pos0 = 0; //Starting position of stepper motor
int Pos1 = 0;



void setup() {                
 
  //Serial.begin(9600); //Only used for debugging, slows system down else
  pinMode(step0, OUTPUT); // Set motor control
  pinMode(dir0, OUTPUT);
  pinMode(step1, OUTPUT);
  pinMode(dir1, OUTPUT); 
  
  
  //All input switches pulled HIGH via 10k resistors, active LOW
  
  pinMode(Limit0, INPUT); // Set limit switches
  pinMode(Limit1, INPUT);
  pinMode(Reset, INPUT);

  orient0(); //Orient cameras. Will set intial Pos0 / Pos1 values
  orient1();

}


// Main Loop
void loop() {

  check0();
  check1();
  checkswitches();
  
}


//Subroutines
void check0() {

  getpot0(); // Get new value
  
  if (Pos0 > (Pot0 + 1)) //Are we higher than this?
  {
    stepper0CL(); //Rotate one step clockwise  
    Pos0 = Pos0 - 1;
  }  

  if (Pos0 < (Pot0 - 1)) //Are we lower than this?
  {
    stepper0CCL(); //Rotate one step counter-clockwise
    Pos0 = Pos0 + 1;
  }  

}

void check1() {

  getpot1(); // Get new value


  if (Pos1 > (Pot1 + 1)) //Are we higher than this?
  {
    stepper1CL(); //Rotate one step clockwise
    Pos1 = Pos1 - 1;
  }  

  if (Pos1 < (Pot1 - 1)) //Are we lower than this?
  {
    stepper1CCL(); //Rotate one step counter-clockwise             
    Pos1 = Pos1 + 1;
  }

}


void checkswitches() { //Check the HOME and other switches

  button = digitalRead(Reset); 
  if (button == LOW) { // Reset button pressed?
  orient0(); //Re-zero both cameras
  orient1();
  }


}



void getpot0() {
  
  Pot0 = analogRead(A1);
  
  //Serial.print(Pot0, DEC);
  //Serial.print(" ");  


  Pot0 = Pot0 - 468; //Lob off bottom values
  Pot0 = Pot0 / 2.37; // RECALCULATE to divide into 90 degrees of motion
  Pot0 = 200 - Pot0; //Invert,
 
  //delay(1);

}

void getpot1() {
  
  Pot1 = analogRead(A0);

  //Serial.print(Pot1, DEC);
  //Serial.println("");    
  
  Pot1 = Pot1 - 424; //Lob off bottom values
  Pot1 = Pot1 / 2.12; // Divide into 90 degrees of motion
  Pot1 = 200 - Pot1; //Invert the value

  //delay(1);

}
 
 
void orient0() {// Goto limit switch 0 home

  button = digitalRead(Limit0); //Pre-fetch this in case, for some reason, we're already there.

  while(button == HIGH) {//Keep doing this until button is clicked to LOW
  
  stepper0CCL(); //Rotate one step towards limit switch
  
  delay(5);
  
  button = digitalRead(Limit0);
  
  }

// Set this as ZERO, and once we're in the main loop, system will make camera match slide lever.

  Pos0 = 200;

}


void orient1() {// Goto limit switch 0 home

  button = digitalRead(Limit1); //Pre-fetch this in case, for some reason, we're already there.

  while(button == HIGH) {//Keep doing this until button is clicked to LOW
  
  stepper1CCL(); //Rotate one step towards limit switch
  
  delay(5);
  
  button = digitalRead(Limit1);
  
  }

// Set this as ZERO, and once we're in the main loop, system will make camera match slide lever.

  Pos1 = 200;

}


void stepper0CCL() {
  
    digitalWrite(dir0, HIGH);
    digitalWrite(step0, HIGH);
    delayMicroseconds(2);
    digitalWrite(step0, LOW);
    delayMicroseconds(DelayT); 

}

void stepper0CL() {
  
    digitalWrite(dir0, LOW);
    digitalWrite(step0, HIGH);
    delayMicroseconds(2);
    digitalWrite(step0, LOW);
    delayMicroseconds(DelayT); 

}  

void stepper1CCL() {
  
    digitalWrite(dir1, HIGH);
    digitalWrite(step1, HIGH);
    delayMicroseconds(2);
    digitalWrite(step1, LOW);
    delayMicroseconds(DelayT); 

}

void stepper1CL() {
  
    digitalWrite(dir1, LOW);
    digitalWrite(step1, HIGH);
    delayMicroseconds(2);
    digitalWrite(step1, LOW);
    delayMicroseconds(DelayT); 

}  
