' Benheck System 2 Pinball Sound Driver
' 2010-2011 Benjamin J Heckendorn
' Audio CPU device #: 253

' Plays stereo music + mono SFX + mono speech
' Full volume and mixer control, allows panning of mono elements, clean fades and pop elimination

'Cog Usage:

'0 = Main Kernel
'1 = Command Processor (ML)
'2 = Fade Control (Spin)

'3 = Speech and sfx player (2 channels of mono) (ML)
'4 = Music player (1 channel stereo) (ML)

'5 = SPI0 - Speech (ML)
'6 = SPI1 - Sound FX (ML)
'7 = SPI2 - Music (ML)


 
CON


_clkmode = xtal1 + pll16x
_xinfreq = 5_000_000       '80 MHz
                                          
buffSize = 50
buffdouble = 100

SCL = 20    'I2C digital potentiometer
SDT = 21

ATN = 25
CLK = 26
SDA = 27



    
VAR


    long parameter1  'to pass @buff1 to ASM
    long parameter2  'to pass @buff2 to ASM
    long parameter3  'to pass sample rate to ASM
    long parameter4  'to pass #samples to ASM
    long parameter5  'to pass @buff1 to ASM
    long parameter6  'to pass @buff2 to ASM
    long parameter7  'to pass sample rate to ASM
    long parameter8  'to pass #samples to ASM
         
    word buff1s[buffSize]
    word buff2s[buffSize]
    
    word buff1f[buffSize]
    word buff2f[buffSize]

    byte Header[44]
    
    byte speechload[7]
    byte SFXload[7]

    
    long Sj
    long Sn
    long Fj
    long Fn

    long SpeechEnable
    long SFXEnable
    long MusicEnable

    long CogStackFade[9]
    byte volume

    byte MusicCommand           'Commands the music fader what to do
    word MP1                    'Fader parameter 1
    word MP2                    'Fader parameter 2
    byte VolumeMusic            'Universal volume of music (set by itself, or is changed by faders)

    byte SFXCommand           'Commands the music fader what to do
    word SP1                    'Fader parameter 1
    word SP2                    'Fader parameter 2
    byte SFXPan            'Universal volume of music (set by itself, or is changed by faders)    


VAR ' I/O routine variables


    long parameterA  'to pass @buffer to ASM
    long parameterB
    byte buffer[1024]
    word Pointer
    byte TextOutput[62]
    
    byte Line

    
    
OBJ

    sd0  : "fat16_0"
    sd1  : "fat16_1"
    music : "CPU_audio_music"
    comm : "CPU_audio_command"

    
    d  : "debug"

      
PUB Initialize | i, g, timer

dira[ATN]~
dira[CLK]~
dira[SDA]~

speechload[0] := 115             'Put "sXX.wav" into the string once
speechload[3] := 46
speechload[4] := 119
speechload[5] := 97
speechload[6] := 118

SFXload[0] := 102             'Put "fXX.wav" into the string once
SFXload[3] := 46
SFXload[4] := 119
SFXload[5] := 97
SFXload[6] := 118

d.Contrast(25)                        
d.CursorON
d.Bright(8)
d.clr

SFXSetPan(255)




COGINIT(2,FadeControl,@CogStackFade)                    'Start fade control that will constantly update the digital potentiometers


waitcnt(40_000_000 + cnt)  

d.dbtext(string("SD0-MUSIC:"),0)

music.MountSD(@MusicEnable)     'Mount SD0 for Music and pass address for Music Enable

d.dbtext(string("OK"),1)



d.dbtext(string("SD1-SFX:"),0)

i:=sd1.mount(4)                 'Mount SD1 for sound FX

d.dbtext(string("OK"),1)



'd.dbtext(string("SD2-SPEECH:"),0) 

'i:=sd0.mount(8)                 'Mount SD0 for speech

'd.dbtext(string("OK"),1)


d.dbtext(string("AUDIO SYSTEMS OK"),1)

waitcnt(40_000_000 + cnt)  

d.clr

parameter1:=@buff1s[0]
parameter2:=@buff2s[0]
parameter3:=@SpeechEnable
parameter4:=0

parameter5:=@buff1f[0]
parameter6:=@buff2f[0]
parameter7:=@SFXEnable
parameter8:=0
  
SpeechEnable := 0
SFXEnable := 0
MusicEnable := 0

COGINIT(3,@ASMsound,@parameter1) 'Start speech and SFX cog


parameterA := @buffer[0]
COGINIT(1,@Setup,@parameterA)   'Start command processor, ready to rock!
Pointer := 0                    'Set command pointer to start and wait for command 


d.clr
d.dbtext(string("Ready for Command"),1)




'------------------------------------------------------------------------New Main Loop--------------------------------------------------------  
repeat

  if buffer[Pointer + 63] == 255                        'Is there a new line in the buffer? 
    if buffer[Pointer] == 253                           'Is it for us?
      Interpet                                          'Decode it!
    else                                                'Oh. It's not for us.
      LineDone                                          'Erase and move pointer
    




'----------------------------------------------------------Loops to Continually Fill Mono Sound Buffers---------------------------------------------------------------


  if MusicEnable
    music.play

  if SpeechEnable
    if Sj == buffdouble  'repeat until end of file
    
      if (buff1s[Sn]==0)
        Sj:=sd0.pread(@buff1s, buffdouble) 'read data words to input stereo buffer   

      if (buff2s[Sn]==0)
        Sj:=sd0.pread(@buff2s, buffdouble) 'read data words to input stereo buffer

    if Sj <> buffdouble
      sd0.pclose



  if SFXEnable
    if Fj == buffdouble  'repeat until end of file
    
      if (buff1f[Fn]==0)
        Fj:=sd1.pread(@buff1f, buffdouble) 'read data words to input stereo buffer   

      if (buff2f[Fn]==0)
        Fj:=sd1.pread(@buff2f, buffdouble) 'read data words to input stereo buffer

    if Fj <> buffdouble
      sd1.pclose


PUB Interpet | command, parm1, parm2, parm3, parm4

d.clr

'Get commands from buffer
Command := byte[@Buffer][Pointer + 1]
Parm1 := byte[@Buffer][Pointer + 2] 
Parm2 := byte[@Buffer][Pointer + 3] 
Parm3 := byte[@Buffer][Pointer + 4] 
Parm4 := byte[@Buffer][Pointer + 5] 


'Now figure out what to do

'Sound FX related commands:
if Command == 102              '"f" Play a sound fx clip?
  SFX(Parm1, Parm2)
  SFXVolume(Parm3)              'Set intial volume
  d.dbtext(string("Play SFX:"), 0)   
  d.dbtext(@Parm1, 0)   
  d.dbtext(@Parm2, 0)
    
if Command == 90               '"Z" Pan sound fx channel?
  SFXPanner(Parm1, Parm2)       'destination , speed
   
if Command == 89               '"Y" Set pan location?
  SFXSetPan(Parm1)              'Location 0 (left) 128 (center) 255 (right)
  
if Command == 88               '"X" Set mono volume?
  SFXVolume(Parm1)              '0-255


'Music related commands:
if Command == 109               '"m" Start a music file?
  MusicSlider(0,0)              'Slide to zero
  Music.Start(Parm1, Parm2)     'Group, clip (use any valid characters for great justice)
  MusicSlider(Parm3, Parm4)     'Slide up to new
  d.dbtext(string("Play Music:"), 0)   
  d.dbtext(@Parm1, 0)   
  d.dbtext(@Parm2, 0) 
  
if Command == 84                '"T" Fade music to position?
  MusicSlider(Parm1, Parm2)     'Destination volume, speed
  d.dbtext(string("Fade Music to:"), 0)
  d.dbDEC(Parm1)

'Got 'em, erase line and switch to next
LineDone  


PUB LineDone | g                    'Changes the flags on the buffer to mark 


'ALL COMMANDS MUST DO THIS ONCE THEY ARE COMPLETE!

bytefill(@Buffer + Pointer, 0, 64)                      'Erase this line of the buffer

Pointer += 64                   'Increment pointer
if Pointer == 1024              'Reached the top?
  pointer := 0                  'Reset

'bytefill(@buffer + Pointer, 0, 64)













PUB Speech(group, clip) | i, SampleRate, Samples

speechload[1] := group + 64
speechload[2] := clip + 64

sd0.pclose 'Close anything that might have been open
      
i:=sd0.popen(@speechload, "r")
if (i<>0)
  repeat

i:=sd0.pread(@Header, 44)
  
Samples:=Header[43]<<24+Header[42]<<16+Header[41]<<8+Header[40]
Samples:=Samples>>1
 
Sn:=buffSize-1
Sj:=buffdouble   'number of bytes to read

parameter4 := Samples

SpeechEnable := 255 '255 means Load and Start Sound



PUB SFX(group, clip) | i, SampleRate, Samples

SFXload[1] := group '+ 64
SFXload[2] := clip '+ 64

sd1.pclose 'Close anything that might have been open
      
i:=sd1.popen(@SFXload, "r")
if (i<>0)
  repeat

i:=sd1.pread(@Header, 44)
  
Samples:=Header[43]<<24+Header[42]<<16+Header[41]<<8+Header[40]
Samples:=Samples>>1
 
Fn:=buffSize-1
Fj:=buffdouble   'number of bytes to read

parameter8 := Samples

SFXEnable := 255 '255 means Load and Start Sound




PUB FadeControl | timer0, timer1

dbINIT  'Start I2C digital pots


'Main loop that looks for commands, and branches off when there are

repeat

  if MusicCommand == 1           'Slides music to new volume
    MusicCommand := 11          'Set busy mode
    timer0 := 0                 'Reset timer


  if MusicCommand == 11         'Active slide?
    timer0 += 1
      if timer0 > MP2
        timer0 := 0

        MusicVolume(VolumeMusic)            'Set music volume to whatever they asked it to be    
        if VolumeMusic < MP1
          VolumeMusic += 1
        if VolumeMusic > MP1
          VolumeMusic -= 1
        if VolumeMusic == MP1       'Did we get there?
          MusicClear                'Command finished


  if SFXCommand == 1
    SFXCommand := 11
    timer1 := 0

  if SFXCommand == 11
    timer1 += 1
      if timer1 > SP2
        timer1 := 0

        SFXSetPan(SFXPan) 
        if SFXPan < SP1
          SFXPan += 1
        if SFXPan > SP1
          SFXPan -= 1
        if SFXPan == SP1
          SFXClear              



PUB MusicSlider(vol, speed)     'Command "T", volume, speed

MP1 := vol
MP2 := speed
MusicCommand := 1




PUB MusicVolume(vol)            'This routine is called by the fader cog, or by the main program.

VolumeMusic := vol

dbSTART
dbWrite(%01011100)            'Select digital pot for music
dbWrite(%10101111)            'We're going to write the same value on both pots (stereo fade)
dbWrite(vol)               'Write value
dbStop                        'End process





PUB SFXPanner(destination, speed) 'Command: "Z", destination, speed

SP1 := destination
SP2 := speed
SFXCommand := 1

 

PUB SFXSetPan(location)         'Command "Y", location

SFXPan := location

dbSTART
dbWrite(%01010000)            'Select digital pot for music
dbWrite(%10101001)            'Writing to left and right pots to set pan.
dbWrite(255 - location)                  'Write left value
dbWrite(location)                  'Write right value
dbStop                        'End process



PUB SFXVolume(vol)              'Command "X" volume

dbSTART
dbWrite(%01010000)            'Select digital pot for music
dbWrite(%10101111)            'Write same value to both pots (mono)
dbWrite(vol)                  'Write value
dbStop                        'End process







PUB MusicClear

MusicCommand := 0
MP1 := 0
MP2 := 0


PUB SFXClear

SFXCommand := 0
SP1 := 0
SP2 := 0








PUB dbINIT             ' An I2C device may be left in an
                    '  invalid state and may need to be
   outa[SCL] := 1                       '   reinitialized.  Drive SCL high.
   dira[SCL] := 1
   dira[SDT] := 0                       ' Set SDA as input
   repeat 9
      outa[SCL] := 0                    ' Put out up to 9 clock pulses
      outa[SDT] := 1
      if ina[SDT]                      ' Repeat if SDA not driven high
         quit                          '  by the EEPROM



PUB dbSTART                  ' SDA goes HIGH to LOW with SCL HIGH

   outa[SCL]~~                         ' Initially drive SCL HIGH
   dira[SCL]~~
   outa[SDT]~~                         ' Initially drive SDA HIGH
   dira[SDT]~~
   outa[SDT]~                          ' Now drive SDA LOW
   outa[SCL]~                          ' Leave SCL LOW


 
PUB dbSTOP                     ' SDA goes LOW to HIGH with SCL High

   outa[SCL]~~                         ' Drive SCL HIGH
   outa[SDT]~~                         '  then SDA HIGH
   dira[SCL]~                          ' Now let them float
   dira[SDT]~                          ' If pullups present, they'll stay HIGH



PUB dbWRITE(data1) : ackbit

   ackbit := 0 
   data1 <<= 24
   repeat 8                            ' Output data to SDA
      outa[SDT] := (data1 <-= 1) & 1
      outa[SCL]~~                      ' Toggle SCL from LOW to HIGH to LOW
      outa[SCL]~
   dira[SDT]~                          ' Set SDA to input for ACK/NAK
   outa[SCL]~~
   ackbit := ina[SDT]                  ' Sample SDA when SCL is HIGH
   outa[SCL]~
   outa[SDT]~                          ' Leave SDA driven LOW
   dira[SDT]~~



 
DAT
  ORG 0
ASMsound
'load input parameters from hub to cog given address in par
        movd    :par,#sData1             
        mov     x,par
        mov     y,#8  'input 8 parameters
:par    rdlong  0,x
        add     :par,dlsb
        add     x,#4    'Align Long
        djnz    y,#:par

startup
        'setup output pins
        MOV DMaskR,#1
        ROL DMaskR,OPinR
        OR DIRA, DMaskR
        
        MOV DMaskL,#1
        ROL DMaskL,OPinL
        OR DIRA, DMaskL

        'setup counters
        MOV CTRA,CountModeR
        MOV CTRB,CountModeL

        'setup loop counter
        MOV WaitCount, CNT
        ADD WaitCount,Rate


MainLoop
        waitcnt WaitCount,Rate  'No matter what, wait correct number of cycles

CheckSpeech          
        RDLONG speechgo, sEnable 'Look at the Speech Enable memory location
        CMP Zero, speechgo wc  'See if it's above zero (1= play >1 = start)
        IF_C JMP #LoadSpeech

CheckSFX
        RDLONG SFXgo, fEnable 'Look at the Speech Enable memory location
        CMP Zero, SFXgo wc  'See if it's above zero (1= play >1 = start)
        IF_C JMP #LoadSFX
        
        JMP #MainLoop


'---------SPEECH DRIVER--------------------    

LoadSpeech
        CMP speechgo, One wz    'Has speech already started?
        IF_Z JMP #PlaySpeech    'If so, jump to PlaySpeech

        MOV sLoopCount,SizeBuff 'Reset buffer size 
        MOV sData,sData1        'Point to start of data
        MOV sTable,#1           'Set table # to 1
        RDLONG sSamples, sGetSamples 'Get # of samples
        
        WRLONG One, sEnable     'Set sEnable to 1 (speech started)

PlaySpeech
        SUB sSamples,#1
        CMP sSamples,#0 wz
        IF_Z JMP #SpeechDone

        RDWORD Right,sData
        ADD Right,twos  
        SHL Right, #16
        
        MOV FRQA, Right

        WRWORD Zero, sData
        ADD sData, #2

        DJNZ sLoopCount,#CheckSFX 'If table is not yet empty, continue  
        
        MOV sLoopCount,SizeBuff        
        CMP sTable,#1 wz
        IF_Z JMP #SwitchToTable2s
        
SwitchToTable1s
        MOV sTable,#1
        MOV sData,sData1
        JMP #CheckSFX
        
SwitchToTable2s
        MOV sTable,#2
        MOV sData,sData2
        JMP #CheckSFX
                
SpeechDone
        WRLONG Zero, sEnable
        JMP #CheckSFX




'---------SOUND FX DRIVER--------------------

LoadSFX
        CMP SFXgo, One wz    'Has speech already started?
        IF_Z JMP #PlaySFX    'If so, jump to PlaySpeech

        MOV fLoopCount,SizeBuff 'Reset buffer size 
        MOV fData,fData1        'Point to start of data
        MOV fTable,#1           'Set table # to 1
        RDLONG fSamples, fGetSamples 'Get # of samples
        
        WRLONG One, fEnable     'Set sEnable to 1 (speech started)

PlaySFX 
        SUB fSamples,#1
        CMP fSamples,#0 wz
        IF_Z JMP #SFXDone

        RDWORD Left, fData
        ADD Left, twos  
        SHL Left, #16
        
        MOV FRQB, Left

        WRWORD Zero, fData
        ADD fData, #2

        DJNZ fLoopCount,#MainLoop 'If table is not yet empty, continue  
        
        MOV fLoopCount, SizeBuff        
        CMP fTable,#1 wz
        IF_Z JMP #SwitchToTable2f
        
SwitchToTable1f
        MOV fTable,#1
        MOV fData, fData1
        JMP #MainLoop
        
SwitchToTable2f
        MOV fTable,#2
        MOV fData, fData2
        JMP #MainLoop
                
SFXDone
        WRLONG Zero, fEnable
        JMP #MainLoop

                        

'Working variables
x       long 0
y       long 0
dlsb    long    1 << 9
twos    long $0000_8000
        
'Loop parameters
sTable  long 0
fTable  long 0
WaitCount long 0

sData   long 0
sSamples long 0
fSamples long 0
fData   long 0


sLoopCount long 0
fLoopCount long 0
  
SizeBuff long buffsize

Right   long 0
Left    long 0
Zero    long 0          
One     long 1

Rate    long 1814 'Clocks between samples for 44100 audio

speechgo long 0
SFXgo   long 0


'setup parameters
DMaskR  long 0 'right output mask
OPinR   long 17 'right channel output pin #                        '   <---------  Change Right pin# here !!!!!!!!!!!!!!    
DMaskL  long 0 'left output mask 
OPinL   long 16 'left channel output pin #                         '   <---------  Change Left pin# here !!!!!!!!!!!!!!    

CountModeR long %00011000_00000000_00000000_00010001                            'Pin 16
CountModeL long %00011000_00000000_00000000_00010000                            'Pin 17


'input parameters
sData1   long 0 'Address of first data table        
sData2   long 0 'Address of second data table
sEnable  long 0 'Flag to enable speech to play 
sGetSamples long 0 'Number of samples

fData1   long 0 'Address of first data table        
fData2   long 0 'Address of second data table
fEnable  long 0 'Flag to enable speech to play 
fGetSamples long 0 'Number of samples






DAT

ORG 0

Setup

        mov dira, OutputMask

        mov OutputMask, par     'Its work done, OutputMask is now used to set the parameter register
        rdlong pData1, OutputMask
        
        mov pData, pData1       'Setup main memory data pointer
        mov NextLine, pData     'Set start of memory as line #
        mov buffertop, pData    'Load starting address into Buffertop
        add buffertop, buffersize  'Add 1024 to find the Top of Memory 

        mov Databyte, #0
        mov DataMask, #1        

Wait4Command                    'Wait for Attention to go high, then we'll fill bits. If it's already high, we just continue.

        mov Check, ina
        and Check, Attention
        cmp Check, Attention wz
        if_z jmp #StartRead
        jmp #Wait4Command

StartRead
        mov EndOfLine, pData
        add EndOfLine, #63

Wait4ClockHigh
        mov Check, ina
        and Check, Attention
        cmp Check, Attention wc
        if_c jmp #EndFill                'If ATN is still high, keep getting bits

        mov Check, ina
        and Check, Clock
        cmp Check, Clock wz
        if_z jmp #FillData        
        jmp #Wait4ClockHigh

FillData
        mov Check, ina
        and Check, Data
        cmp Check, Data wz
        if_z add Databyte, DataMask
        shl DataMask, #1  
        
Wait4ClockLow

        mov Check, ina
        and Check, Clock
        cmp Check, Clock wz
        if_z jmp #Wait4ClockLow                 'If clock is still HIGH, keep waiting for it not to be.       

        cmp DataMaskEnd, DataMask wz
        if_z jmp #WriteByte                     
                     
CheckATN

        mov Check, ina
        and Check, Attention
        cmp Check, Attention wc
        if_c jmp #EndFill                'If ATN is still high, keep getting bits
        jmp #Wait4ClockHigh 
                                                'If ATN goes low, transmission over, set Trigger Byte

WriteByte
        wrbyte Databyte, pData
        mov Databyte, #0
        mov DataMask, #1
        add pData, #1
        
        jmp #CheckATN


EndFill
        add NextLine, #64                       'Increment line number by 64
        cmp NextLine, buffertop wz              'See if it's gone past the top of memory
        if_z mov NextLine, pData1               'If it did, reset line number to start of buffer
        
        mov pData, NextLine                      'Regardless, set pData to start of next line

        wrbyte TByte, EndOfLine        
        jmp #Wait4Command




'Variables

DataMask long 0
Check      long 0
buffertop  long 0
pData    long 0
EndOfLine   long 0
NextLine long 0
Databyte byte 0
pData1   long 0 'Address of first data table       
 
'Declarations

TByte byte 255                                          'End of line flag
buffersize long 1024
OutputMask long %00000000_00000000_00000000_00000000
Attention  long %00000010_00000000_00000000_00000000  
Clock      long %00000100_00000000_00000000_00000000
Data       long %00001000_00000000_00000000_00000000
Datamaskend long %00000000_00000000_00000001_00000000 

 

 



