'  ASM WAV Player Ver. 1b  (Plays only stereo, 16-bit PCM WAV files from SD card)
 
CON

    _clkmode = xtal1 + pll16x
    _xinfreq = 5_000_000       '80 MHz
                                          
    buffSize = 50
    buffquad = 200
    
VAR long parameter1  'to pass @buff1 to ASM
    long parameter2  'to pass @buff2 to ASM
    long parameter3  'to pass sample rate to ASM
    long parameter4  'to pass #samples to ASM
    long buff1[buffSize]
    long buff2[buffSize]
    byte Header[44]

    byte musicload[7] 
    long n
    long j
    long MusicEnableAddr
    
OBJ

    sd2  : "fat16_2"

      
PUB MountSD(enable_addr) | i

MusicEnableAddr := enable_addr

musicload[0] := 109             'Put "mXX.wav" into the string once
musicload[3] := 46
musicload[4] := 119
musicload[5] := 97
musicload[6] := 118
 
i:=sd2.mount(0)
if (i<>0)
  repeat

parameter1 := @buff1[0]
parameter2 := @buff2[0]
parameter3 := enable_addr       'Get address for Music Enable
parameter4 := 0

COGINIT(4,@ASMWAV,@parameter1)  'Start up ML player

 

PUB Start(group, clip) | i, SampleRate, Samples

musicload[1] := group '+ 64
musicload[2] := clip '+ 64

sd2.pclose 'Close anything that might have been open
    
i:=sd2.popen(@musicload, "r")
if (i<>0)
  repeat

i:=sd2.pread(@Header, 44)
  
Samples:=Header[43]<<24+Header[42]<<16+Header[41]<<8+Header[40]
Samples:=Samples>>2

n := buffSize-1
j := buffquad   'number of bytes to read

parameter4:=Samples

Long[MusicEnableAddr] := 255



PUB Play
  
if j == buffquad
    
  if (buff1[n]==0)
    j:=sd2.pread(@buff1, buffquad) 'read data words to input stereo buffer   

  if (buff2[n]==0)
    j:=sd2.pread(@buff2, buffquad) 'read data words to input stereo buffer

if j <> buffquad
  sd2.pclose


 

 
DAT
  ORG 0
ASMWAV
'load input parameters from hub to cog given address in par
        movd    :par,#pData1             
        mov     x,par
        mov     y,#4  'input 4 parameters
:par    rdlong  0,x
        add     :par,dlsb
        add     x,#4
        djnz    y,#:par

setup
        'setup output pins
        MOV DMaskR,#1
        ROL DMaskR,OPinR
        OR DIRA, DMaskR
        MOV DMaskL,#1
        ROL DMaskL,OPinL
        OR DIRA, DMaskL

        OR CountModeR,OPinR
        MOV CTRA,CountModeR
        OR CountModeL,OPinL
        MOV CTRB,CountModeL



        MOV WaitCount, CNT
        ADD WaitCount,dRate


MainLoop

        waitcnt WaitCount, dRate  'No matter what, wait correct number of cycles

CheckMusic         
        RDLONG MusicGo, mEnable 'Look at the Speech Enable memory location
        CMP Zero, MusicGo wc  'See if it's above zero (1= play >1 = start)
        IF_C JMP #LoadMusic

        JMP #MainLoop

LoadMusic
        CMP MusicGo, One wz    'Has speech already started?
        IF_Z JMP #PlayMusic    'If so, jump to PlaySpeech

        MOV LoopCount,SizeBuff  
        MOV pData,pData1
        MOV nTable,#1
        RDLONG mSamples, mGetSamples

        WRLONG One, mEnable     'Set sEnable to 1 (speech started)

        
PlayMusic
        SUB mSamples,#1
        CMP mSamples,#0 wz
        IF_Z JMP #MusicDone

        RDLONG Right,pData
        ADD Right,twos      'Going to cheat a bit with the LSBs here...  Probably shoud fix this!    
        MOV FRQA,Right
        ROL Right,#16       '16 LSBs are left channel...
        MOV FRQB,Right
        WRLONG Zero,pData
        ADD pData,#4

        'loop
        DJNZ LoopCount,#MainLoop
        
        MOV LoopCount,SizeBuff        
        'switch table       ?
        CMP nTable,#1 wz
        IF_Z JMP #SwitchToTable2
SwitchToTable1
        MOV nTable,#1
        MOV pData,pData1
        JMP #MainLoop
SwitchToTable2
        MOV nTable,#2
        MOV pData,pData2
        JMP #MainLoop
        
                
MusicDone
        MOV FRQA, Zero
        MOV FRQB, Zero
         
        WRLONG Zero, mEnable    'Set Music Enable to 0 (off)
        JMP #MainLoop           'Go back to main loop and wait for next music
               

'Working variables
thisCog long 0
x       long 0
y       long 0
dlsb    long    1 << 9
BigWait long 100000
twos    long $8000_8000
        
'Loop parameters
nTable  long 0
WaitCount long 0
pData   long 0
LoopCount long 0
SizeBuff long buffsize
'Left    long 0
Right   long 0
Zero    long 0
One     long 1
dRate   long 1814
mSamples long 0          
MusicGo long 0

'setup parameters
DMaskR  long 0 'right output mask
OPinR   long 18 'right channel output pin #                        '   <---------  Change Right pin# here !!!!!!!!!!!!!!    
DMaskL  long 0 'left output mask 
OPinL   long 19 'left channel output pin #                         '   <---------  Change Left pin# here !!!!!!!!!!!!!!    
CountModeR long %00011000_00000000_00000000_00000000
CountModeL long %00011000_00000000_00000000_00000000


'input parameters
pData1   long 0 'Address of first data table        
pData2   long 0 'Address of second data table
mEnable  long 0
mGetSamples long 0