' Datalogger Test
' 2-21-11 BJH


CON

_clkmode = xtal1 + pll16x
_xinfreq = 5_000_000       '80 MHz


SCL = 4 'I2C display
SDT = 5

Rsense = 7
Lsense = 6
Soap = 16


VAR

  byte col
  byte line
  byte X
  byte Scrmem[81]
  byte DATABYTE

  byte CRNL[2]
  
  byte filename[12]

  long Rcount
  long Lcount

  
OBJ

    sd0  : "fat16_0"



PUB Main | g, checksum


bytefill(@scrmem,32,80)

Contrast(25)                        
CursorON
Bright(8)
CLR

filename[0] := 77
filename[1] := 77
filename[2] := 45
filename[3] := 68
filename[4] := 68
filename[5] := 45
filename[6] := 89
filename[7] := 89
filename[8] := 46
filename[9] := 84
filename[10] := 88
filename[11] := 84


CRNL[0] := 13
CRNL[1] := 10

DIRA[Rsense]~ 'Right sensor
DIRA[Lsense]~  'Left sensor

DIRA[Soap]~   'Soap sensor

clr
dbtext(string("Equalizing..."),1)

repeat while ina[Lsense]
repeat while ina[Rsense]

Rcount := 0
Lcount := 0 

dbtext(string("Ready"),1)


'Watch for movement and determine direction
repeat

  if ina[Rsense]
    checksum := 0
    repeat 3000
      checksum += ina[Rsense]
    if checksum > 2000
      RightEntry

  if ina[Lsense]
    checksum := 0
    repeat 3000
      checksum += ina[Lsense]
    if checksum > 2000
      LeftEntry


PUB RightEntry | time



repeat while ina[Lsense] 'Wait for subject to exit left

clr
dbtext(string("Right to left"),1)

WaitForNoMotion





PUB LeftEntry | time



repeat while ina[Rsense]


clr
dbtext(string("Left To Right"),1)


WaitForNoMotion




PUB WaitForNoMotion | counter

dbtext(string("Waiting for Motion Clear..."),1)
 
repeat while counter < 50_000

  if ina[Rsense] == 0
    Counter += 1

  if ina[Lsense] == 0
    Counter += 1

Rcount := 0
Lcount := 0

clr
dbtext(string("Ready"),1)


PUB SDrun | g




repeat
 
dbtext(string("SD mount: "),0)

g := sd0.mount(0)
  
dbtext(string("Success!"),1)


dbtext(string("File:"),0)

g := sd0.popen(@filename, "a")  'A= append file. Creates a new file if one doesn't exist.  
if g == -1
  dbtext(string("Fail!!"),1)
  repeat
  
dbtext(string("Success!"),1)



dbtext(string("Writing..."),0)
 
 
WriteLine(string("Hello world!"))


g := sd0.pclose  

dbtext(string("Done!"),1)








PUB WriteLine(str_addr) | g, size
 
size := strsize(str_addr)

g := sd0.pwrite(str_addr, size)
EndOfLine



PUB EndOfLine | g

'Can also be used to make a blank line

g := sd0.pwrite(@CRNL, 2)



PUB Alert | g                   'Pulses brightness of LCD to get attention

repeat 3

  repeat g from 8 to 1
    Bright(g)
    waitcnt((CLKFREQ / 1000)* 30 + cnt) 

  repeat g from 1 to 8
    Bright(g)
    waitcnt((CLKFREQ / 1000)* 30 + cnt)
 
Bright(8)

PUB CursorON

dbSTART

dbWrite($FE) 
dbWrite($4B)               

dbSTOP

PUB CursorOFF

dbSTART

dbWrite($FE) 
dbWrite($4C)                

dbSTOP


PUB Contrast(temp)

dbSTART

dbWrite($FE) 
dbWrite($52)  
dbWrite(temp)               'Set contrast 1-50 (low to high)

dbSTOP

PUB Bright(temp)

dbSTART

dbWrite($FE) 
dbWrite($53)  
dbWrite(temp)               'Set brightness 1-8 

dbSTOP

PUB POS(curx,cury) | realline   'Position the cursor, using old Atari BASIC language :)

if cury == 1
  realline := 0
if cury == 2
  realline := 64 
if cury == 3
  realline := 20
if cury == 4
  realline := 84


dbSTART
  
dbWrite($FE) 
dbWrite($45) 
dbWrite(realline+ (curx - 1))

dbSTOP 

PUB CLR                         'Clears screen, sets cursor/line to 1/1

dbSTART

dbWrite($FE) 
dbWrite($51)              'Clear screen
col := 1
line := 1

dbSTOP 


PUB CR                          'Perform carriage-return (like there's even a mechanical carriage anymore)
                                'Only call from within other operations, since it does not contain its own START-STOP condition
col := 1
line := line + 1
if line == 5
  line := 1 
POS(col,line)

PUB Writescreen(temp)

Scrmem[x] := temp


PUB Message(str_addr)

POS(1,4)
dbText(string("                    "),0)
POS(1,4)
dbText(str_addr,0)  

PUB dbTEXT(stringptr,crbit) | temp, temp1, g, gg, count                      'Prints text. 0 = no carriage return, 1= carriage return
                                                                             'Includes word-wrap for fun & profit.
dbSTART 
g := 0
count := 0

  repeat strsize(stringptr)
    temp := byte[stringptr + g]
    dbWrite(temp)
    col := col + 1
    g := g + 1

    if temp == 32                                       'Check if next word will fit on current line.
      gg := g
      count := col
       repeat   
         if byte[stringptr + gg] == 32 or byte[stringptr + gg] == 0 
          quit 
         gg := gg + 1
         count := count + 1
      if count > 21                                     'If not, put cursor past limit to initiate carriage return.
        col := 21
  
    if col == 21
      col := 1
      line := line + 1
      dbSTOP
      POS(col,line)
      dbSTART
      if byte[stringptr + g] == 32
        g := g + 1

    
if crbit
  CR



PUB dbDEC(value) | i

'' Print a decimal number

dbSTART

  if value < 0
    -value
    dbWrite("-")

  i := 1_000_000_000

  repeat 10
    if value => i
      dbWrite(value / i + "0")
      value //= i
      result~~
    elseif result or i == 1
      dbWrite("0")
    i /= 10     

CR

dbSTOP 

PUB dbBIN(value, digits)

'' Print a binary number

dbSTART

  value <<= 32 - digits
  repeat digits
    dbWrite((value <-= 1) & 1 + "0")

CR

dbSTOP 





PUB dbINIT             ' An I2C device may be left in an
                    '  invalid state and may need to be
   outa[SCL] := 1                       '   reinitialized.  Drive SCL high.
   dira[SCL] := 1
   dira[SDT] := 0                       ' Set SDA as input
   repeat 9
      outa[SCL] := 0                    ' Put out up to 9 clock pulses
      outa[SDT] := 1
      if ina[SDT]                      ' Repeat if SDA not driven high
         quit                          '  by the EEPROM

PUB dbSTART                  ' SDA goes HIGH to LOW with SCL HIGH

   outa[SCL]~~                         ' Initially drive SCL HIGH
   dira[SCL]~~
   outa[SDT]~~                         ' Initially drive SDA HIGH
   dira[SDT]~~
   outa[SDT]~                          ' Now drive SDA LOW
   outa[SCL]~                          ' Leave SCL LOW

   dbWrite(254)              'Call address of I2C device, LCD screen 
  
PUB dbSTOP                     ' SDA goes LOW to HIGH with SCL High

   outa[SCL]~~                         ' Drive SCL HIGH
   outa[SDT]~~                         '  then SDA HIGH
   dira[SCL]~                          ' Now let them float
   dira[SDT]~                          ' If pullups present, they'll stay HIGH

PUB dbWRITE(data1) : ackbit

   ackbit := 0 
   data1 <<= 24
   repeat 8                            ' Output data to SDA
      outa[SDT] := (data1 <-= 1) & 1
      outa[SCL]~~                      ' Toggle SCL from LOW to HIGH to LOW
      outa[SCL]~
   dira[SDT]~                          ' Set SDA to input for ACK/NAK
   outa[SCL]~~
   ackbit := ina[SDT]                  ' Sample SDA when SCL is HIGH
   outa[SCL]~
   outa[SDT]~                          ' Leave SDA driven LOW
   dira[SDT]~~


