#include <Wire.h>

short w = 0;
short s = 0;
short a = 0;
short d = 0;

short xOut = 0;
short yOut = 0; 

const int deadZone = 1;  //Amount a key must be pressed before analog registers

void setup() {

  analogReference(DEFAULT);

  Wire.begin(); // join i2c bus (address optional for master)
  
  //Serial.begin(9600);

}

void loop() {
  
  
  //Default is NO movement.
  xOut = 128;
  yOut = 128;
  
  // read the value from the sensor:
  w = analogRead(A0);                  //Effective range: 522 - 542    
  s = analogRead(A1);                  //Effective range: 522 - 539
  a = analogRead(A2);                  //Effective range: 525 - 545
  d = analogRead(A3);                  //Effective range: 526 - 546

  //Convert to value 0-20, then convert to 0-128

  w = (20 - (542 - w)) * 6.4;
  s = (17 - (539 - s)) * 7.529;
  a = (20 - (545 - a)) * 6.4;
  d = (20 - (546 - d)) * 6.4;
  
  if (s > deadZone) {  //Going backwards?

    xOut = 128 - s;
    
    if (xOut < 0) {
      
      xOut = 0;
      
    }
  
  }
  
  if (w > deadZone) {  //Going forward?

    xOut = 128 + w;

    
    if (xOut > 255) {
      
      xOut = 255;
      
    }
  
  }
  
  if (a > deadZone) {  //Going left?

    yOut = 128 - a;

    
    if (yOut < 0) {
      
      yOut = 0;
      
    }
  
  }


  if (d > deadZone) {  //Going right?

    yOut = 128 + d;
    
    if (yOut > 255) {
      
      yOut = 255;
      
    }
  
  }
  
  
  //Serial.print(xOut);
  //Serial.print(" ");
  //Serial.print(yOut);
  //Serial.println(" ");

  Wire.beginTransmission(40);

  Wire.write(B10101001);            // Command - set Pot0
  Wire.write(yOut);                 // Send left/right signal to Pot0 
  Wire.write(xOut);                 // Send forward/back signal to Pot1 
  Wire.endTransmission();           // stop transmitting
                
}
