#include <Wire.h>

short w = 0;
short s = 0;
short a = 0;
short d = 0;

short xOut = 0;
short yOut = 0; 

const int deadZone = 1;  //Amount a key must be pressed before analog registers


void setup() {

  analogReference(DEFAULT);

  Wire.begin(); // join i2c bus (address optional for master)
  
  //Serial.begin(9600);

}

void loop() {
  
  
  //Default is NO movement.
  xOut = 128;
  yOut = 128;
  
  // read the value from the sensor:
  d = analogRead(A0);                  //Effective range: 475 - 276 (199 / 128)    
  a = analogRead(A1);                  //Effective range: 562 - 938 (376 / 128)
  s = analogRead(A2);                  //Effective range: 465 - 135 (330 / 128)
  w = analogRead(A3);                  //Effective range: 456 - 57  (399 / 128)

  
  setValues();                        //Compute values and send data to the Digital pot
  
  //Serial.print(a);
  //Serial.print(" ");
  //Serial.print(d);
  //Serial.println(" ");
              
}


void setValues() {

  if (w < 470) {                      //Going forward?

    w = (199 - (w - 276)) / 1.55;             //Calculate the range by converting into steps of 128

    xOut = 128 + w;                   //Set the yPot value to this range
    
    if (xOut > 255) {                 //Make sure we didn't exceed range
      
      xOut = 255;
      
    }
  
  }
  
  if (s > 570) {                      //Going backwards?

    s = (s - 562) / 2.93;              //Calculate the range by converting into steps of 128

    xOut = 128 - s;                   //Set the yPot value to this range
    
    if (xOut < 0) {                   //Make sure we didn't exceed range
      
      xOut = 0;
      
    }
  
  }
  

  
  if (a < 460) {                      //Going left?

    a = (330 - (a - 135)) / 2.58;             //Calculate the range by converting into steps of 128

    yOut = 128 - a;                   //Set the xPot value to this range
   
    if (yOut < 0) {                   //Make sure we didn't exceed range
      
      yOut = 0;
      
    }
  
  }


  if (d < 450) {                      //Going right?

    d = (399 - (d - 57)) / 3.12;              //Calculate the range by converting into steps of 128

    yOut = 128 + d;                   //Set the xPot value to this range
    
    if (yOut > 255) {                 //Make sure we didn't exceed range
      
      yOut = 255;
      
    }
  
  }  

  Wire.beginTransmission(40);
  Wire.write(B10101001);            // Command - set Pot0
  Wire.write(yOut);                 // Send left/right signal to Pot0 
  Wire.write(xOut);                 // Send forward/back signal to Pot1 
  Wire.endTransmission();           // stop transmitting 
  
  
}
