#include <SD.h>

const int Charge = 825;      //The over/under telling us if current is being drawn

const int chipSelect = 10;
const int Alarm = 7;
const int GraceTime = 10000;  //Grace period to insert the phone, in milliseconds.
String dataString = "";
int pTimer = 0;               //Cycle timer, approximately 1 millisecond per unit
int Status = 0;               //State of phone, see below:
//States:
//0 = Car turned on, grace period
//1 = Phone detected upon car turned on within grace period
//2 = Phone NOT plugged in until after grace period.

void setup()
{
  Serial.begin(9600);
  
  pinMode(Alarm, 1);
  analogReference(DEFAULT);

  Serial.print("Initializing SD card...");
  if (!SD.begin(chipSelect)) {
    Serial.println("Card failed, or not present");
    return;
  }
  Serial.println("Done.");
}

void loop() {                        //When the car / power starts, this loop executes.

  pTimer += 1;                      //Increment timer
  delay(1);                         //Pad timer
  
  if (analogRead(A0) > Charge) {      //Current being drawn?

    digitalWrite(Alarm, 0);        //No matter what, this turns OFF the alarm.
    Status = 1;                                          //Phone detected upon car turned on within grace period
 
    File dataFile = SD.open("good.txt", FILE_WRITE);    //Open "Good" file and set to WRITE so we can append a line      
    if (dataFile) {                                     //Make sure it opened.          
      if (pTimer < 10) {                                 //Phone plugged in as car started?
        dataFile.println("Car started with phone in dock.");
        dataFile.close();
      }   
    }      
    else {
        Serial.println("error opening datalog.txt");      //Else, error
    }    
  }
 
  if ((analogRead(A0) < Charge) and (pTimer >= GraceTime)) {    //Phone not drawing current after grace period?

    dataString = "";

    digitalWrite(Alarm, 1);                                  //No matter what else, sound the alarm

    if (Status == 0) {                                       //Phone wasn't previously docked?
        File dataFile = SD.open("bad.txt", FILE_WRITE);     
        if (dataFile) {       
            dataFile.println("Car started with phone NOT INSERTED within grace period!");
            dataFile.close();   
        }      
        else {
            Serial.println("error opening datalog.txt");      //Else, error
        } 
       Status = 2;                                           //Set status so this message is only printed once.           
    }
    if (Status == 1) {                                       //Phone was in the dock?
        File dataFile = SD.open("bad.txt", FILE_WRITE);  
        if (dataFile) {          
            dataFile.print("Phone removed from dock while running after ");
            dataString += String((pTimer / 1000) /60);      //Convert timer to minutes
            dataFile.print(dataString);
            dataFile.println(" minutes!");
            dataFile.close();   
        }      
        else {
            Serial.println("error opening datalog.txt");      //Else, error
        } 
       Status = 2;                                            //Set status so this message is only printed once.            
    }


    
  }

}




